/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditablePort;
import io.fabric8.docker.api.model.Port;
import io.fabric8.docker.api.model.PortFluent;
import io.fabric8.docker.api.model.PortFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PortBuilder
extends PortFluentImpl<PortBuilder>
implements VisitableBuilder<Port, PortBuilder> {
    PortFluent<?> fluent;

    public PortBuilder() {
        this(new Port());
    }

    public PortBuilder(PortFluent<?> fluent) {
        this(fluent, new Port());
    }

    public PortBuilder(PortFluent<?> fluent, Port instance) {
        this.fluent = fluent;
        fluent.withIP(instance.getIP());
        fluent.withPrivatePort(instance.getPrivatePort());
        fluent.withPublicPort(instance.getPublicPort());
        fluent.withType(instance.getType());
    }

    public PortBuilder(Port instance) {
        this.fluent = this;
        this.withIP(instance.getIP());
        this.withPrivatePort(instance.getPrivatePort());
        this.withPublicPort(instance.getPublicPort());
        this.withType(instance.getType());
    }

    @Override
    public EditablePort build() {
        EditablePort buildable = new EditablePort(this.fluent.getIP(), this.fluent.getPrivatePort(), this.fluent.getPublicPort(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PortBuilder that = (PortBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

