/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableImage;
import io.fabric8.docker.api.model.Image;
import io.fabric8.docker.api.model.ImageFluent;
import io.fabric8.docker.api.model.ImageFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ImageBuilder
extends ImageFluentImpl<ImageBuilder>
implements VisitableBuilder<Image, ImageBuilder> {
    ImageFluent<?> fluent;

    public ImageBuilder() {
        this(new Image());
    }

    public ImageBuilder(ImageFluent<?> fluent) {
        this(fluent, new Image());
    }

    public ImageBuilder(ImageFluent<?> fluent, Image instance) {
        this.fluent = fluent;
        fluent.withCreated(instance.getCreated());
        fluent.withId(instance.getId());
        fluent.withLabels(instance.getLabels());
        fluent.withParentId(instance.getParentId());
        fluent.withRepoDigests(instance.getRepoDigests());
        fluent.withRepoTags(instance.getRepoTags());
        fluent.withSize(instance.getSize());
        fluent.withVirtualSize(instance.getVirtualSize());
    }

    public ImageBuilder(Image instance) {
        this.fluent = this;
        this.withCreated(instance.getCreated());
        this.withId(instance.getId());
        this.withLabels(instance.getLabels());
        this.withParentId(instance.getParentId());
        this.withRepoDigests(instance.getRepoDigests());
        this.withRepoTags(instance.getRepoTags());
        this.withSize(instance.getSize());
        this.withVirtualSize(instance.getVirtualSize());
    }

    @Override
    public EditableImage build() {
        EditableImage buildable = new EditableImage(this.fluent.getCreated(), this.fluent.getId(), this.fluent.getLabels(), this.fluent.getParentId(), this.fluent.getRepoDigests(), this.fluent.getRepoTags(), this.fluent.getSize(), this.fluent.getVirtualSize());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageBuilder that = (ImageBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

