/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerPathStat;
import io.fabric8.docker.api.model.ContainerPathStatFluent;
import io.fabric8.docker.api.model.ContainerPathStatFluentImpl;
import io.fabric8.docker.api.model.EditableContainerPathStat;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerPathStatBuilder
extends ContainerPathStatFluentImpl<ContainerPathStatBuilder>
implements VisitableBuilder<ContainerPathStat, ContainerPathStatBuilder> {
    ContainerPathStatFluent<?> fluent;

    public ContainerPathStatBuilder() {
        this(new ContainerPathStat());
    }

    public ContainerPathStatBuilder(ContainerPathStatFluent<?> fluent) {
        this(fluent, new ContainerPathStat());
    }

    public ContainerPathStatBuilder(ContainerPathStatFluent<?> fluent, ContainerPathStat instance) {
        this.fluent = fluent;
        fluent.withLinkTarget(instance.getLinkTarget());
        fluent.withMode(instance.getMode());
        fluent.withMtime(instance.getMtime());
        fluent.withName(instance.getName());
        fluent.withSize(instance.getSize());
    }

    public ContainerPathStatBuilder(ContainerPathStat instance) {
        this.fluent = this;
        this.withLinkTarget(instance.getLinkTarget());
        this.withMode(instance.getMode());
        this.withMtime(instance.getMtime());
        this.withName(instance.getName());
        this.withSize(instance.getSize());
    }

    @Override
    public EditableContainerPathStat build() {
        EditableContainerPathStat buildable = new EditableContainerPathStat(this.fluent.getLinkTarget(), this.fluent.getMode(), this.fluent.getMtime(), this.fluent.getName(), this.fluent.getSize());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerPathStatBuilder that = (ContainerPathStatBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

