package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class PortBindingBuilder extends PortBindingFluentImpl<PortBindingBuilder> implements VisitableBuilder<PortBinding,PortBindingBuilder>{

     PortBindingFluent<?> fluent;
public PortBindingBuilder(){
    this(new PortBinding());
}
public PortBindingBuilder( PortBindingFluent<?> fluent ){
    this(fluent, new PortBinding());
}
public PortBindingBuilder( PortBindingFluent<?> fluent , PortBinding instance ){
    this.fluent = fluent; fluent.withHostIp(instance.getHostIp()); fluent.withHostPort(instance.getHostPort()); 
}
public PortBindingBuilder( PortBinding instance ){
    this.fluent = this; this.withHostIp(instance.getHostIp()); this.withHostPort(instance.getHostPort()); 
}

public EditablePortBinding build(){
    EditablePortBinding buildable = new EditablePortBinding(fluent.getHostIp(),fluent.getHostPort());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
PortBindingBuilder that = (PortBindingBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
