package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.regex.Pattern;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class NetIPNetBuilder extends NetIPNetFluentImpl<NetIPNetBuilder> implements VisitableBuilder<NetIPNet,NetIPNetBuilder>{

     NetIPNetFluent<?> fluent;
public NetIPNetBuilder(){
    this(new NetIPNet());
}
public NetIPNetBuilder( NetIPNetFluent<?> fluent ){
    this(fluent, new NetIPNet());
}
public NetIPNetBuilder( NetIPNetFluent<?> fluent , NetIPNet instance ){
    this.fluent = fluent; fluent.withIp(instance.getIp()); fluent.withMask(instance.getMask()); 
}
public NetIPNetBuilder( NetIPNet instance ){
    this.fluent = this; this.withIp(instance.getIp()); this.withMask(instance.getMask()); 
}

public EditableNetIPNet build(){
    EditableNetIPNet buildable = new EditableNetIPNet(fluent.getIp(),fluent.getMask());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
NetIPNetBuilder that = (NetIPNetBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
