package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;

public interface InfoFluent<T extends InfoFluent<T>> extends Fluent<T>{


    public Boolean isBridgeNfIp6tables();    public T withBridgeNfIp6tables( Boolean BridgeNfIp6tables);    public Boolean isBridgeNfIptables();    public T withBridgeNfIptables( Boolean BridgeNfIptables);    public String getClusterAdvertise();    public T withClusterAdvertise( String ClusterAdvertise);    public String getClusterStore();    public T withClusterStore( String ClusterStore);    public Integer getContainers();    public T withContainers( Integer Containers);    public Boolean isCpuCfsPeriod();    public T withCpuCfsPeriod( Boolean CpuCfsPeriod);    public Boolean isCpuCfsQuota();    public T withCpuCfsQuota( Boolean CpuCfsQuota);    public Boolean isDebug();    public T withDebug( Boolean Debug);    public String getDockerRootDir();    public T withDockerRootDir( String DockerRootDir);    public String getDriver();    public T withDriver( String Driver);    public T addToDriverStatus( Object ...items);    public T removeFromDriverStatus( Object ...items);    public List<Object> getDriverStatus();    public T withDriverStatus( List<Object> DriverStatus);    public T withDriverStatus( Object ...DriverStatus);    public String getExecutionDriver();    public T withExecutionDriver( String ExecutionDriver);    public Boolean isExperimentalBuild();    public T withExperimentalBuild( Boolean ExperimentalBuild);    public String getHttpProxy();    public T withHttpProxy( String HttpProxy);    public String getHttpsProxy();    public T withHttpsProxy( String HttpsProxy);    public String getID();    public T withID( String ID);    public Boolean isIPv4Forwarding();    public T withIPv4Forwarding( Boolean IPv4Forwarding);    public Integer getImages();    public T withImages( Integer Images);    public String getIndexServerAddress();    public T withIndexServerAddress( String IndexServerAddress);    public String getInitPath();    public T withInitPath( String InitPath);    public String getInitSha1();    public T withInitSha1( String InitSha1);    public String getKernelVersion();    public T withKernelVersion( String KernelVersion);    public T addToLabels( String ...items);    public T removeFromLabels( String ...items);    public List<String> getLabels();    public T withLabels( List<String> Labels);    public T withLabels( String ...Labels);    public String getLoggingDriver();    public T withLoggingDriver( String LoggingDriver);    public Long getMemTotal();    public T withMemTotal( Long MemTotal);    public Boolean isMemoryLimit();    public T withMemoryLimit( Boolean MemoryLimit);    public Integer getNCPU();    public T withNCPU( Integer NCPU);    public Integer getNEventsListener();    public T withNEventsListener( Integer NEventsListener);    public Integer getNFd();    public T withNFd( Integer NFd);    public Integer getNGoroutines();    public T withNGoroutines( Integer NGoroutines);    public String getName();    public T withName( String Name);    public String getNoProxy();    public T withNoProxy( String NoProxy);    public Boolean isOomKillDisable();    public T withOomKillDisable( Boolean OomKillDisable);    public String getOperatingSystem();    public T withOperatingSystem( String OperatingSystem);    public ServiceConfig getRegistryConfig();    public T withRegistryConfig( ServiceConfig RegistryConfig);    public RegistryConfigNested<T> withNewRegistryConfig();    public RegistryConfigNested<T> withNewRegistryConfigLike( ServiceConfig item);    public RegistryConfigNested<T> editRegistryConfig();    public String getServerVersion();    public T withServerVersion( String ServerVersion);    public Boolean isSwapLimit();    public T withSwapLimit( Boolean SwapLimit);    public String getSystemTime();    public T withSystemTime( String SystemTime);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface RegistryConfigNested<N> extends Nested<N>, ServiceConfigFluent<RegistryConfigNested<N>>{
            public N endRegistryConfig();            public N and();        
}


}
