package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class DeviceMappingBuilder extends DeviceMappingFluentImpl<DeviceMappingBuilder> implements VisitableBuilder<DeviceMapping,DeviceMappingBuilder>{

     DeviceMappingFluent<?> fluent;
public DeviceMappingBuilder(){
    this(new DeviceMapping());
}
public DeviceMappingBuilder( DeviceMappingFluent<?> fluent ){
    this(fluent, new DeviceMapping());
}
public DeviceMappingBuilder( DeviceMappingFluent<?> fluent , DeviceMapping instance ){
    this.fluent = fluent; fluent.withCgroupPermissions(instance.getCgroupPermissions()); fluent.withPathInContainer(instance.getPathInContainer()); fluent.withPathOnHost(instance.getPathOnHost()); 
}
public DeviceMappingBuilder( DeviceMapping instance ){
    this.fluent = this; this.withCgroupPermissions(instance.getCgroupPermissions()); this.withPathInContainer(instance.getPathInContainer()); this.withPathOnHost(instance.getPathOnHost()); 
}

public EditableDeviceMapping build(){
    EditableDeviceMapping buildable = new EditableDeviceMapping(fluent.getCgroupPermissions(),fluent.getPathInContainer(),fluent.getPathOnHost());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DeviceMappingBuilder that = (DeviceMappingBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
