package io.fabric8.docker.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class DefaultNetworkSettingsFluentImpl<T extends DefaultNetworkSettingsFluent<T>> extends BaseFluent<T> implements DefaultNetworkSettingsFluent<T>{

     String EndpointID;     String Gateway;     String GlobalIPv6Address;     Integer GlobalIPv6PrefixLen;     String IPAddress;     Integer IPPrefixLen;     String IPv6Gateway;     String MacAddress;     Map<String, Object> additionalProperties = new HashMap();
public DefaultNetworkSettingsFluentImpl(){
    
}
public DefaultNetworkSettingsFluentImpl( DefaultNetworkSettings instance ){
    this.withEndpointID(instance.getEndpointID()); this.withGateway(instance.getGateway()); this.withGlobalIPv6Address(instance.getGlobalIPv6Address()); this.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen()); this.withIPAddress(instance.getIPAddress()); this.withIPPrefixLen(instance.getIPPrefixLen()); this.withIPv6Gateway(instance.getIPv6Gateway()); this.withMacAddress(instance.getMacAddress()); 
}

    public String getEndpointID(){
    return this.EndpointID;
    }
    public T withEndpointID( String EndpointID){
    this.EndpointID=EndpointID; return (T) this;
    }
    public String getGateway(){
    return this.Gateway;
    }
    public T withGateway( String Gateway){
    this.Gateway=Gateway; return (T) this;
    }
    public String getGlobalIPv6Address(){
    return this.GlobalIPv6Address;
    }
    public T withGlobalIPv6Address( String GlobalIPv6Address){
    this.GlobalIPv6Address=GlobalIPv6Address; return (T) this;
    }
    public Integer getGlobalIPv6PrefixLen(){
    return this.GlobalIPv6PrefixLen;
    }
    public T withGlobalIPv6PrefixLen( Integer GlobalIPv6PrefixLen){
    this.GlobalIPv6PrefixLen=GlobalIPv6PrefixLen; return (T) this;
    }
    public String getIPAddress(){
    return this.IPAddress;
    }
    public T withIPAddress( String IPAddress){
    this.IPAddress=IPAddress; return (T) this;
    }
    public Integer getIPPrefixLen(){
    return this.IPPrefixLen;
    }
    public T withIPPrefixLen( Integer IPPrefixLen){
    this.IPPrefixLen=IPPrefixLen; return (T) this;
    }
    public String getIPv6Gateway(){
    return this.IPv6Gateway;
    }
    public T withIPv6Gateway( String IPv6Gateway){
    this.IPv6Gateway=IPv6Gateway; return (T) this;
    }
    public String getMacAddress(){
    return this.MacAddress;
    }
    public T withMacAddress( String MacAddress){
    this.MacAddress=MacAddress; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DefaultNetworkSettingsFluentImpl that = (DefaultNetworkSettingsFluentImpl) o;
if (EndpointID != null ? !EndpointID.equals(that.EndpointID) :that.EndpointID != null) return false;
if (Gateway != null ? !Gateway.equals(that.Gateway) :that.Gateway != null) return false;
if (GlobalIPv6Address != null ? !GlobalIPv6Address.equals(that.GlobalIPv6Address) :that.GlobalIPv6Address != null) return false;
if (GlobalIPv6PrefixLen != null ? !GlobalIPv6PrefixLen.equals(that.GlobalIPv6PrefixLen) :that.GlobalIPv6PrefixLen != null) return false;
if (IPAddress != null ? !IPAddress.equals(that.IPAddress) :that.IPAddress != null) return false;
if (IPPrefixLen != null ? !IPPrefixLen.equals(that.IPPrefixLen) :that.IPPrefixLen != null) return false;
if (IPv6Gateway != null ? !IPv6Gateway.equals(that.IPv6Gateway) :that.IPv6Gateway != null) return false;
if (MacAddress != null ? !MacAddress.equals(that.MacAddress) :that.MacAddress != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
