package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class DefaultNetworkSettingsBuilder extends DefaultNetworkSettingsFluentImpl<DefaultNetworkSettingsBuilder> implements VisitableBuilder<DefaultNetworkSettings,DefaultNetworkSettingsBuilder>{

     DefaultNetworkSettingsFluent<?> fluent;
public DefaultNetworkSettingsBuilder(){
    this(new DefaultNetworkSettings());
}
public DefaultNetworkSettingsBuilder( DefaultNetworkSettingsFluent<?> fluent ){
    this(fluent, new DefaultNetworkSettings());
}
public DefaultNetworkSettingsBuilder( DefaultNetworkSettingsFluent<?> fluent , DefaultNetworkSettings instance ){
    this.fluent = fluent; fluent.withEndpointID(instance.getEndpointID()); fluent.withGateway(instance.getGateway()); fluent.withGlobalIPv6Address(instance.getGlobalIPv6Address()); fluent.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen()); fluent.withIPAddress(instance.getIPAddress()); fluent.withIPPrefixLen(instance.getIPPrefixLen()); fluent.withIPv6Gateway(instance.getIPv6Gateway()); fluent.withMacAddress(instance.getMacAddress()); 
}
public DefaultNetworkSettingsBuilder( DefaultNetworkSettings instance ){
    this.fluent = this; this.withEndpointID(instance.getEndpointID()); this.withGateway(instance.getGateway()); this.withGlobalIPv6Address(instance.getGlobalIPv6Address()); this.withGlobalIPv6PrefixLen(instance.getGlobalIPv6PrefixLen()); this.withIPAddress(instance.getIPAddress()); this.withIPPrefixLen(instance.getIPPrefixLen()); this.withIPv6Gateway(instance.getIPv6Gateway()); this.withMacAddress(instance.getMacAddress()); 
}

public EditableDefaultNetworkSettings build(){
    EditableDefaultNetworkSettings buildable = new EditableDefaultNetworkSettings(fluent.getEndpointID(),fluent.getGateway(),fluent.getGlobalIPv6Address(),fluent.getGlobalIPv6PrefixLen(),fluent.getIPAddress(),fluent.getIPPrefixLen(),fluent.getIPv6Gateway(),fluent.getMacAddress());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DefaultNetworkSettingsBuilder that = (DefaultNetworkSettingsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
