package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;
import java.util.List;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class ContainerFluentImpl<T extends ContainerFluent<T>> extends BaseFluent<T> implements ContainerFluent<T>{

     String id;     List<String> names = new ArrayList();     String image;     String imageId;     String command;     Long created;     List<VisitableBuilder<Port, ?>> ports = new ArrayList();     Long sizeRw;     Long sizeRootFs;     Map<String, String> labels = new HashMap();     String status;     VisitableBuilder<ContainerHostConfig, ?> hostConfig;     VisitableBuilder<NetworkSettings, ?> summaryNetworkSettings;
public ContainerFluentImpl(){
    
}
public ContainerFluentImpl( Container instance ){
    this.withId(instance.getId()); this.withNames(instance.getNames()); this.withImage(instance.getImage()); this.withImageId(instance.getImageId()); this.withCommand(instance.getCommand()); this.withCreated(instance.getCreated()); this.withPorts(instance.getPorts()); this.withSizeRw(instance.getSizeRw()); this.withSizeRootFs(instance.getSizeRootFs()); this.withLabels(instance.getLabels()); this.withStatus(instance.getStatus()); this.withHostConfig(instance.getHostConfig()); this.withSummaryNetworkSettings(instance.getSummaryNetworkSettings()); 
}

    public String getId(){
    return this.id;
    }
    public T withId( String id){
    this.id=id; return (T) this;
    }
    public T addToNames( String ...items){
    for (String item : items) {this.names.add(item);} return (T)this;
    }
    public T removeFromNames( String ...items){
    for (String item : items) {this.names.remove(item);} return (T)this;
    }
    public List<String> getNames(){
    return this.names;
    }
    public T withNames( List<String> names){
    this.names.clear();if (names != null) {for (String item : names){this.addToNames(item);}} return (T) this;
    }
    public T withNames( String ...names){
    this.names.clear(); if (names != null) {for (String item :names){ this.addToNames(item);}} return (T) this;
    }
    public String getImage(){
    return this.image;
    }
    public T withImage( String image){
    this.image=image; return (T) this;
    }
    public String getImageId(){
    return this.imageId;
    }
    public T withImageId( String imageId){
    this.imageId=imageId; return (T) this;
    }
    public String getCommand(){
    return this.command;
    }
    public T withCommand( String command){
    this.command=command; return (T) this;
    }
    public Long getCreated(){
    return this.created;
    }
    public T withCreated( Long created){
    this.created=created; return (T) this;
    }
    public T addToPorts( Port ...items){
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.add(builder);this.ports.add(builder);} return (T)this;
    }
    public T removeFromPorts( Port ...items){
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.remove(builder);this.ports.remove(builder);} return (T)this;
    }
    public List<Port> getPorts(){
    return build(ports);
    }
    public T withPorts( List<Port> ports){
    this.ports.clear();if (ports != null) {for (Port item : ports){this.addToPorts(item);}} return (T) this;
    }
    public T withPorts( Port ...ports){
    this.ports.clear(); if (ports != null) {for (Port item :ports){ this.addToPorts(item);}} return (T) this;
    }
    public PortsNested<T> addNewPort(){
    return new PortsNestedImpl<T>();
    }
    public PortsNested<T> addNewPortLike( Port item){
    return new PortsNestedImpl<T>(item);
    }
    public T addNewPort( String IP,  Integer PrivatePort,  Integer PublicPort,  String Type){
    return addToPorts(new Port(IP, PrivatePort, PublicPort, Type));
    }
    public Long getSizeRw(){
    return this.sizeRw;
    }
    public T withSizeRw( Long sizeRw){
    this.sizeRw=sizeRw; return (T) this;
    }
    public Long getSizeRootFs(){
    return this.sizeRootFs;
    }
    public T withSizeRootFs( Long sizeRootFs){
    this.sizeRootFs=sizeRootFs; return (T) this;
    }
    public T addToLabels( String key,  String value){
    if(key != null && value != null) {this.labels.put(key, value);} return (T)this;
    }
    public T addToLabels( Map<String, String> map){
    if(map != null) { this.labels.putAll(map);} return (T)this;
    }
    public T removeFromLabels( String key){
    if(key != null) {this.labels.remove(key);} return (T)this;
    }
    public T removeFromLabels( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.labels.remove(key);}} return (T)this;
    }
    public Map<String, String> getLabels(){
    return this.labels;
    }
    public T withLabels( Map<String, String> labels){
    this.labels.clear();if (labels != null) {this.labels.putAll(labels);} return (T) this;
    }
    public String getStatus(){
    return this.status;
    }
    public T withStatus( String status){
    this.status=status; return (T) this;
    }
    public ContainerHostConfig getHostConfig(){
    return this.hostConfig!=null?this.hostConfig.build():null;
    }
    public T withHostConfig( ContainerHostConfig hostConfig){
    if (hostConfig!=null){ this.hostConfig= new ContainerHostConfigBuilder(hostConfig); _visitables.add(this.hostConfig);} return (T) this;
    }
    public HostConfigNested<T> withNewHostConfig(){
    return new HostConfigNestedImpl<T>();
    }
    public HostConfigNested<T> withNewHostConfigLike( ContainerHostConfig item){
    return new HostConfigNestedImpl<T>(item);
    }
    public HostConfigNested<T> editHostConfig(){
    return withNewHostConfigLike(getHostConfig());
    }
    public T withNewHostConfig( String networkMode){
    return withHostConfig(new ContainerHostConfig(networkMode));
    }
    public NetworkSettings getSummaryNetworkSettings(){
    return this.summaryNetworkSettings!=null?this.summaryNetworkSettings.build():null;
    }
    public T withSummaryNetworkSettings( NetworkSettings summaryNetworkSettings){
    if (summaryNetworkSettings!=null){ this.summaryNetworkSettings= new NetworkSettingsBuilder(summaryNetworkSettings); _visitables.add(this.summaryNetworkSettings);} return (T) this;
    }
    public SummaryNetworkSettingsNested<T> withNewSummaryNetworkSettings(){
    return new SummaryNetworkSettingsNestedImpl<T>();
    }
    public SummaryNetworkSettingsNested<T> withNewSummaryNetworkSettingsLike( NetworkSettings item){
    return new SummaryNetworkSettingsNestedImpl<T>(item);
    }
    public SummaryNetworkSettingsNested<T> editSummaryNetworkSettings(){
    return withNewSummaryNetworkSettingsLike(getSummaryNetworkSettings());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerFluentImpl that = (ContainerFluentImpl) o;
if (id != null ? !id.equals(that.id) :that.id != null) return false;
if (names != null ? !names.equals(that.names) :that.names != null) return false;
if (image != null ? !image.equals(that.image) :that.image != null) return false;
if (imageId != null ? !imageId.equals(that.imageId) :that.imageId != null) return false;
if (command != null ? !command.equals(that.command) :that.command != null) return false;
if (created != null ? !created.equals(that.created) :that.created != null) return false;
if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
if (sizeRw != null ? !sizeRw.equals(that.sizeRw) :that.sizeRw != null) return false;
if (sizeRootFs != null ? !sizeRootFs.equals(that.sizeRootFs) :that.sizeRootFs != null) return false;
if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
if (status != null ? !status.equals(that.status) :that.status != null) return false;
if (hostConfig != null ? !hostConfig.equals(that.hostConfig) :that.hostConfig != null) return false;
if (summaryNetworkSettings != null ? !summaryNetworkSettings.equals(that.summaryNetworkSettings) :that.summaryNetworkSettings != null) return false;
return true;

    }

    public class PortsNestedImpl<N> extends PortFluentImpl<PortsNested<N>> implements PortsNested<N>{

        private final PortBuilder builder;
    
             PortsNestedImpl (){
        this.builder = new PortBuilder(this);
        }
             PortsNestedImpl ( Port item){
        this.builder = new PortBuilder(this, item);
        }
    
            public N endPort(){
            return and();
        }
            public N and(){
            return (N) ContainerFluentImpl.this.addToPorts(builder.build());
        }
    
}
    public class HostConfigNestedImpl<N> extends ContainerHostConfigFluentImpl<HostConfigNested<N>> implements HostConfigNested<N>{

        private final ContainerHostConfigBuilder builder;
    
             HostConfigNestedImpl (){
        this.builder = new ContainerHostConfigBuilder(this);
        }
             HostConfigNestedImpl ( ContainerHostConfig item){
        this.builder = new ContainerHostConfigBuilder(this, item);
        }
    
            public N and(){
            return (N) ContainerFluentImpl.this.withHostConfig(builder.build());
        }
            public N endHostConfig(){
            return and();
        }
    
}
    public class SummaryNetworkSettingsNestedImpl<N> extends NetworkSettingsFluentImpl<SummaryNetworkSettingsNested<N>> implements SummaryNetworkSettingsNested<N>{

        private final NetworkSettingsBuilder builder;
    
             SummaryNetworkSettingsNestedImpl (){
        this.builder = new NetworkSettingsBuilder(this);
        }
             SummaryNetworkSettingsNestedImpl ( NetworkSettings item){
        this.builder = new NetworkSettingsBuilder(this, item);
        }
    
            public N and(){
            return (N) ContainerFluentImpl.this.withSummaryNetworkSettings(builder.build());
        }
            public N endSummaryNetworkSettings(){
            return and();
        }
    
}


}
