package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.Fluent;

public class BlkioStatEntryBuilder extends BlkioStatEntryFluentImpl<BlkioStatEntryBuilder> implements VisitableBuilder<BlkioStatEntry,BlkioStatEntryBuilder>{

     BlkioStatEntryFluent<?> fluent;
public BlkioStatEntryBuilder(){
    this(new BlkioStatEntry());
}
public BlkioStatEntryBuilder( BlkioStatEntryFluent<?> fluent ){
    this(fluent, new BlkioStatEntry());
}
public BlkioStatEntryBuilder( BlkioStatEntryFluent<?> fluent , BlkioStatEntry instance ){
    this.fluent = fluent; fluent.withMajor(instance.getMajor()); fluent.withMinor(instance.getMinor()); fluent.withOp(instance.getOp()); fluent.withValue(instance.getValue()); 
}
public BlkioStatEntryBuilder( BlkioStatEntry instance ){
    this.fluent = this; this.withMajor(instance.getMajor()); this.withMinor(instance.getMinor()); this.withOp(instance.getOp()); this.withValue(instance.getValue()); 
}

public EditableBlkioStatEntry build(){
    EditableBlkioStatEntry buildable = new EditableBlkioStatEntry(fluent.getMajor(),fluent.getMinor(),fluent.getOp(),fluent.getValue());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
BlkioStatEntryBuilder that = (BlkioStatEntryBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
