package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class PortBuilder extends PortFluentImpl<PortBuilder> implements VisitableBuilder<Port,PortBuilder>{

     PortFluent<?> fluent;
public PortBuilder(){
    this(new Port());
}
public PortBuilder( PortFluent<?> fluent ){
    this(fluent, new Port());
}
public PortBuilder( PortFluent<?> fluent , Port instance ){
    this.fluent = fluent; fluent.withIP(instance.getIP()); fluent.withPrivatePort(instance.getPrivatePort()); fluent.withPublicPort(instance.getPublicPort()); fluent.withType(instance.getType()); 
}
public PortBuilder( Port instance ){
    this.fluent = this; this.withIP(instance.getIP()); this.withPrivatePort(instance.getPrivatePort()); this.withPublicPort(instance.getPublicPort()); this.withType(instance.getType()); 
}

public EditablePort build(){
    EditablePort buildable = new EditablePort(fluent.getIP(),fluent.getPrivatePort(),fluent.getPublicPort(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
PortBuilder that = (PortBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
