package io.fabric8.docker.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class NetworkSettingsFluentImpl<T extends NetworkSettingsFluent<T>> extends BaseFluent<T> implements NetworkSettingsFluent<T>{

     VisitableBuilder<DefaultNetworkSettings, ?> DefaultNetworkSettings;     VisitableBuilder<NetworkSettingsBase, ?> NetworkSettingsBase;     Map<String, EndpointSettings> Networks = new HashMap();     Map<String, Object> additionalProperties = new HashMap();
public NetworkSettingsFluentImpl(){
    
}
public NetworkSettingsFluentImpl( NetworkSettings instance ){
    this.withDefaultNetworkSettings(instance.getDefaultNetworkSettings()); this.withNetworkSettingsBase(instance.getNetworkSettingsBase()); this.withNetworks(instance.getNetworks()); 
}

    public DefaultNetworkSettings getDefaultNetworkSettings(){
    return this.DefaultNetworkSettings!=null?this.DefaultNetworkSettings.build():null;
    }
    public T withDefaultNetworkSettings( DefaultNetworkSettings DefaultNetworkSettings){
    if (DefaultNetworkSettings!=null){ this.DefaultNetworkSettings= new DefaultNetworkSettingsBuilder(DefaultNetworkSettings); _visitables.add(this.DefaultNetworkSettings);} return (T) this;
    }
    public DefaultNetworkSettingsNested<T> withNewDefaultNetworkSettings(){
    return new DefaultNetworkSettingsNestedImpl<T>();
    }
    public DefaultNetworkSettingsNested<T> withNewDefaultNetworkSettingsLike( DefaultNetworkSettings item){
    return new DefaultNetworkSettingsNestedImpl<T>(item);
    }
    public DefaultNetworkSettingsNested<T> editDefaultNetworkSettings(){
    return withNewDefaultNetworkSettingsLike(getDefaultNetworkSettings());
    }
    public NetworkSettingsBase getNetworkSettingsBase(){
    return this.NetworkSettingsBase!=null?this.NetworkSettingsBase.build():null;
    }
    public T withNetworkSettingsBase( NetworkSettingsBase NetworkSettingsBase){
    if (NetworkSettingsBase!=null){ this.NetworkSettingsBase= new NetworkSettingsBaseBuilder(NetworkSettingsBase); _visitables.add(this.NetworkSettingsBase);} return (T) this;
    }
    public NetworkSettingsBaseNested<T> withNewNetworkSettingsBase(){
    return new NetworkSettingsBaseNestedImpl<T>();
    }
    public NetworkSettingsBaseNested<T> withNewNetworkSettingsBaseLike( NetworkSettingsBase item){
    return new NetworkSettingsBaseNestedImpl<T>(item);
    }
    public NetworkSettingsBaseNested<T> editNetworkSettingsBase(){
    return withNewNetworkSettingsBaseLike(getNetworkSettingsBase());
    }
    public T addToNetworks( String key,  EndpointSettings value){
    if(key != null && value != null) {this.Networks.put(key, value);} return (T)this;
    }
    public T addToNetworks( Map<String, EndpointSettings> map){
    if(map != null) { this.Networks.putAll(map);} return (T)this;
    }
    public T removeFromNetworks( String key){
    if(key != null) {this.Networks.remove(key);} return (T)this;
    }
    public T removeFromNetworks( Map<String, EndpointSettings> map){
    if(map != null) { for(Object key : map.keySet()) {this.Networks.remove(key);}} return (T)this;
    }
    public Map<String, EndpointSettings> getNetworks(){
    return this.Networks;
    }
    public T withNetworks( Map<String, EndpointSettings> Networks){
    this.Networks.clear();if (Networks != null) {this.Networks.putAll(Networks);} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NetworkSettingsFluentImpl that = (NetworkSettingsFluentImpl) o;
if (DefaultNetworkSettings != null ? !DefaultNetworkSettings.equals(that.DefaultNetworkSettings) :that.DefaultNetworkSettings != null) return false;
if (NetworkSettingsBase != null ? !NetworkSettingsBase.equals(that.NetworkSettingsBase) :that.NetworkSettingsBase != null) return false;
if (Networks != null ? !Networks.equals(that.Networks) :that.Networks != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class DefaultNetworkSettingsNestedImpl<N> extends DefaultNetworkSettingsFluentImpl<DefaultNetworkSettingsNested<N>> implements DefaultNetworkSettingsNested<N>{

        private final DefaultNetworkSettingsBuilder builder;
    
             DefaultNetworkSettingsNestedImpl (){
        this.builder = new DefaultNetworkSettingsBuilder(this);
        }
             DefaultNetworkSettingsNestedImpl ( DefaultNetworkSettings item){
        this.builder = new DefaultNetworkSettingsBuilder(this, item);
        }
    
            public N endDefaultNetworkSettings(){
            return and();
        }
            public N and(){
            return (N) NetworkSettingsFluentImpl.this.withDefaultNetworkSettings(builder.build());
        }
    
}
    public class NetworkSettingsBaseNestedImpl<N> extends NetworkSettingsBaseFluentImpl<NetworkSettingsBaseNested<N>> implements NetworkSettingsBaseNested<N>{

        private final NetworkSettingsBaseBuilder builder;
    
             NetworkSettingsBaseNestedImpl (){
        this.builder = new NetworkSettingsBaseBuilder(this);
        }
             NetworkSettingsBaseNestedImpl ( NetworkSettingsBase item){
        this.builder = new NetworkSettingsBaseBuilder(this, item);
        }
    
            public N and(){
            return (N) NetworkSettingsFluentImpl.this.withNetworkSettingsBase(builder.build());
        }
            public N endNetworkSettingsBase(){
            return and();
        }
    
}


}
