package io.fabric8.docker.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;

public class NetworkCreateFluentImpl<T extends NetworkCreateFluent<T>> extends BaseFluent<T> implements NetworkCreateFluent<T>{

     Boolean CheckDuplicate;     String Driver;     VisitableBuilder<IPAM, ?> IPAM;     String Name;     Map<String, String> Options = new HashMap();     Map<String, Object> additionalProperties = new HashMap();
public NetworkCreateFluentImpl(){
    
}
public NetworkCreateFluentImpl( NetworkCreate instance ){
    this.withCheckDuplicate(instance.getCheckDuplicate()); this.withDriver(instance.getDriver()); this.withIPAM(instance.getIPAM()); this.withName(instance.getName()); this.withOptions(instance.getOptions()); 
}

    public Boolean isCheckDuplicate(){
    return this.CheckDuplicate;
    }
    public T withCheckDuplicate( Boolean CheckDuplicate){
    this.CheckDuplicate=CheckDuplicate; return (T) this;
    }
    public String getDriver(){
    return this.Driver;
    }
    public T withDriver( String Driver){
    this.Driver=Driver; return (T) this;
    }
    public IPAM getIPAM(){
    return this.IPAM!=null?this.IPAM.build():null;
    }
    public T withIPAM( IPAM IPAM){
    if (IPAM!=null){ this.IPAM= new IPAMBuilder(IPAM); _visitables.add(this.IPAM);} return (T) this;
    }
    public IPAMNested<T> withNewIPAM(){
    return new IPAMNestedImpl<T>();
    }
    public IPAMNested<T> withNewIPAMLike( IPAM item){
    return new IPAMNestedImpl<T>(item);
    }
    public IPAMNested<T> editIPAM(){
    return withNewIPAMLike(getIPAM());
    }
    public String getName(){
    return this.Name;
    }
    public T withName( String Name){
    this.Name=Name; return (T) this;
    }
    public T addToOptions( String key,  String value){
    if(key != null && value != null) {this.Options.put(key, value);} return (T)this;
    }
    public T addToOptions( Map<String, String> map){
    if(map != null) { this.Options.putAll(map);} return (T)this;
    }
    public T removeFromOptions( String key){
    if(key != null) {this.Options.remove(key);} return (T)this;
    }
    public T removeFromOptions( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.Options.remove(key);}} return (T)this;
    }
    public Map<String, String> getOptions(){
    return this.Options;
    }
    public T withOptions( Map<String, String> Options){
    this.Options.clear();if (Options != null) {this.Options.putAll(Options);} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NetworkCreateFluentImpl that = (NetworkCreateFluentImpl) o;
if (CheckDuplicate != null ? !CheckDuplicate.equals(that.CheckDuplicate) :that.CheckDuplicate != null) return false;
if (Driver != null ? !Driver.equals(that.Driver) :that.Driver != null) return false;
if (IPAM != null ? !IPAM.equals(that.IPAM) :that.IPAM != null) return false;
if (Name != null ? !Name.equals(that.Name) :that.Name != null) return false;
if (Options != null ? !Options.equals(that.Options) :that.Options != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class IPAMNestedImpl<N> extends IPAMFluentImpl<IPAMNested<N>> implements IPAMNested<N>{

        private final IPAMBuilder builder;
    
             IPAMNestedImpl (){
        this.builder = new IPAMBuilder(this);
        }
             IPAMNestedImpl ( IPAM item){
        this.builder = new IPAMBuilder(this, item);
        }
    
            public N endIPAM(){
            return and();
        }
            public N and(){
            return (N) NetworkCreateFluentImpl.this.withIPAM(builder.build());
        }
    
}


}
