package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;

public class InfoFluentImpl<T extends InfoFluent<T>> extends BaseFluent<T> implements InfoFluent<T>{

     Boolean BridgeNfIp6tables;     Boolean BridgeNfIptables;     String ClusterAdvertise;     String ClusterStore;     Integer Containers;     Boolean CpuCfsPeriod;     Boolean CpuCfsQuota;     Boolean Debug;     String DockerRootDir;     String Driver;     List<Object> DriverStatus = new ArrayList();     String ExecutionDriver;     Boolean ExperimentalBuild;     String HttpProxy;     String HttpsProxy;     String ID;     Boolean IPv4Forwarding;     Integer Images;     String IndexServerAddress;     String InitPath;     String InitSha1;     String KernelVersion;     List<String> Labels = new ArrayList();     String LoggingDriver;     Long MemTotal;     Boolean MemoryLimit;     Integer NCPU;     Integer NEventsListener;     Integer NFd;     Integer NGoroutines;     String Name;     String NoProxy;     Boolean OomKillDisable;     String OperatingSystem;     VisitableBuilder<ServiceConfig, ?> RegistryConfig;     String ServerVersion;     Boolean SwapLimit;     String SystemTime;     Map<String, Object> additionalProperties = new HashMap();
public InfoFluentImpl(){
    
}
public InfoFluentImpl( Info instance ){
    this.withBridgeNfIp6tables(instance.getBridgeNfIp6tables()); this.withBridgeNfIptables(instance.getBridgeNfIptables()); this.withClusterAdvertise(instance.getClusterAdvertise()); this.withClusterStore(instance.getClusterStore()); this.withContainers(instance.getContainers()); this.withCpuCfsPeriod(instance.getCpuCfsPeriod()); this.withCpuCfsQuota(instance.getCpuCfsQuota()); this.withDebug(instance.getDebug()); this.withDockerRootDir(instance.getDockerRootDir()); this.withDriver(instance.getDriver()); this.withDriverStatus(instance.getDriverStatus()); this.withExecutionDriver(instance.getExecutionDriver()); this.withExperimentalBuild(instance.getExperimentalBuild()); this.withHttpProxy(instance.getHttpProxy()); this.withHttpsProxy(instance.getHttpsProxy()); this.withID(instance.getID()); this.withIPv4Forwarding(instance.getIPv4Forwarding()); this.withImages(instance.getImages()); this.withIndexServerAddress(instance.getIndexServerAddress()); this.withInitPath(instance.getInitPath()); this.withInitSha1(instance.getInitSha1()); this.withKernelVersion(instance.getKernelVersion()); this.withLabels(instance.getLabels()); this.withLoggingDriver(instance.getLoggingDriver()); this.withMemTotal(instance.getMemTotal()); this.withMemoryLimit(instance.getMemoryLimit()); this.withNCPU(instance.getNCPU()); this.withNEventsListener(instance.getNEventsListener()); this.withNFd(instance.getNFd()); this.withNGoroutines(instance.getNGoroutines()); this.withName(instance.getName()); this.withNoProxy(instance.getNoProxy()); this.withOomKillDisable(instance.getOomKillDisable()); this.withOperatingSystem(instance.getOperatingSystem()); this.withRegistryConfig(instance.getRegistryConfig()); this.withServerVersion(instance.getServerVersion()); this.withSwapLimit(instance.getSwapLimit()); this.withSystemTime(instance.getSystemTime()); 
}

    public Boolean isBridgeNfIp6tables(){
    return this.BridgeNfIp6tables;
    }
    public T withBridgeNfIp6tables( Boolean BridgeNfIp6tables){
    this.BridgeNfIp6tables=BridgeNfIp6tables; return (T) this;
    }
    public Boolean isBridgeNfIptables(){
    return this.BridgeNfIptables;
    }
    public T withBridgeNfIptables( Boolean BridgeNfIptables){
    this.BridgeNfIptables=BridgeNfIptables; return (T) this;
    }
    public String getClusterAdvertise(){
    return this.ClusterAdvertise;
    }
    public T withClusterAdvertise( String ClusterAdvertise){
    this.ClusterAdvertise=ClusterAdvertise; return (T) this;
    }
    public String getClusterStore(){
    return this.ClusterStore;
    }
    public T withClusterStore( String ClusterStore){
    this.ClusterStore=ClusterStore; return (T) this;
    }
    public Integer getContainers(){
    return this.Containers;
    }
    public T withContainers( Integer Containers){
    this.Containers=Containers; return (T) this;
    }
    public Boolean isCpuCfsPeriod(){
    return this.CpuCfsPeriod;
    }
    public T withCpuCfsPeriod( Boolean CpuCfsPeriod){
    this.CpuCfsPeriod=CpuCfsPeriod; return (T) this;
    }
    public Boolean isCpuCfsQuota(){
    return this.CpuCfsQuota;
    }
    public T withCpuCfsQuota( Boolean CpuCfsQuota){
    this.CpuCfsQuota=CpuCfsQuota; return (T) this;
    }
    public Boolean isDebug(){
    return this.Debug;
    }
    public T withDebug( Boolean Debug){
    this.Debug=Debug; return (T) this;
    }
    public String getDockerRootDir(){
    return this.DockerRootDir;
    }
    public T withDockerRootDir( String DockerRootDir){
    this.DockerRootDir=DockerRootDir; return (T) this;
    }
    public String getDriver(){
    return this.Driver;
    }
    public T withDriver( String Driver){
    this.Driver=Driver; return (T) this;
    }
    public T addToDriverStatus( Object ...items){
    for (Object item : items) {this.DriverStatus.add(item);} return (T)this;
    }
    public T removeFromDriverStatus( Object ...items){
    for (Object item : items) {this.DriverStatus.remove(item);} return (T)this;
    }
    public List<Object> getDriverStatus(){
    return this.DriverStatus;
    }
    public T withDriverStatus( List<Object> DriverStatus){
    this.DriverStatus.clear();if (DriverStatus != null) {for (Object item : DriverStatus){this.addToDriverStatus(item);}} return (T) this;
    }
    public T withDriverStatus( Object ...DriverStatus){
    this.DriverStatus.clear(); if (DriverStatus != null) {for (Object item :DriverStatus){ this.addToDriverStatus(item);}} return (T) this;
    }
    public String getExecutionDriver(){
    return this.ExecutionDriver;
    }
    public T withExecutionDriver( String ExecutionDriver){
    this.ExecutionDriver=ExecutionDriver; return (T) this;
    }
    public Boolean isExperimentalBuild(){
    return this.ExperimentalBuild;
    }
    public T withExperimentalBuild( Boolean ExperimentalBuild){
    this.ExperimentalBuild=ExperimentalBuild; return (T) this;
    }
    public String getHttpProxy(){
    return this.HttpProxy;
    }
    public T withHttpProxy( String HttpProxy){
    this.HttpProxy=HttpProxy; return (T) this;
    }
    public String getHttpsProxy(){
    return this.HttpsProxy;
    }
    public T withHttpsProxy( String HttpsProxy){
    this.HttpsProxy=HttpsProxy; return (T) this;
    }
    public String getID(){
    return this.ID;
    }
    public T withID( String ID){
    this.ID=ID; return (T) this;
    }
    public Boolean isIPv4Forwarding(){
    return this.IPv4Forwarding;
    }
    public T withIPv4Forwarding( Boolean IPv4Forwarding){
    this.IPv4Forwarding=IPv4Forwarding; return (T) this;
    }
    public Integer getImages(){
    return this.Images;
    }
    public T withImages( Integer Images){
    this.Images=Images; return (T) this;
    }
    public String getIndexServerAddress(){
    return this.IndexServerAddress;
    }
    public T withIndexServerAddress( String IndexServerAddress){
    this.IndexServerAddress=IndexServerAddress; return (T) this;
    }
    public String getInitPath(){
    return this.InitPath;
    }
    public T withInitPath( String InitPath){
    this.InitPath=InitPath; return (T) this;
    }
    public String getInitSha1(){
    return this.InitSha1;
    }
    public T withInitSha1( String InitSha1){
    this.InitSha1=InitSha1; return (T) this;
    }
    public String getKernelVersion(){
    return this.KernelVersion;
    }
    public T withKernelVersion( String KernelVersion){
    this.KernelVersion=KernelVersion; return (T) this;
    }
    public T addToLabels( String ...items){
    for (String item : items) {this.Labels.add(item);} return (T)this;
    }
    public T removeFromLabels( String ...items){
    for (String item : items) {this.Labels.remove(item);} return (T)this;
    }
    public List<String> getLabels(){
    return this.Labels;
    }
    public T withLabels( List<String> Labels){
    this.Labels.clear();if (Labels != null) {for (String item : Labels){this.addToLabels(item);}} return (T) this;
    }
    public T withLabels( String ...Labels){
    this.Labels.clear(); if (Labels != null) {for (String item :Labels){ this.addToLabels(item);}} return (T) this;
    }
    public String getLoggingDriver(){
    return this.LoggingDriver;
    }
    public T withLoggingDriver( String LoggingDriver){
    this.LoggingDriver=LoggingDriver; return (T) this;
    }
    public Long getMemTotal(){
    return this.MemTotal;
    }
    public T withMemTotal( Long MemTotal){
    this.MemTotal=MemTotal; return (T) this;
    }
    public Boolean isMemoryLimit(){
    return this.MemoryLimit;
    }
    public T withMemoryLimit( Boolean MemoryLimit){
    this.MemoryLimit=MemoryLimit; return (T) this;
    }
    public Integer getNCPU(){
    return this.NCPU;
    }
    public T withNCPU( Integer NCPU){
    this.NCPU=NCPU; return (T) this;
    }
    public Integer getNEventsListener(){
    return this.NEventsListener;
    }
    public T withNEventsListener( Integer NEventsListener){
    this.NEventsListener=NEventsListener; return (T) this;
    }
    public Integer getNFd(){
    return this.NFd;
    }
    public T withNFd( Integer NFd){
    this.NFd=NFd; return (T) this;
    }
    public Integer getNGoroutines(){
    return this.NGoroutines;
    }
    public T withNGoroutines( Integer NGoroutines){
    this.NGoroutines=NGoroutines; return (T) this;
    }
    public String getName(){
    return this.Name;
    }
    public T withName( String Name){
    this.Name=Name; return (T) this;
    }
    public String getNoProxy(){
    return this.NoProxy;
    }
    public T withNoProxy( String NoProxy){
    this.NoProxy=NoProxy; return (T) this;
    }
    public Boolean isOomKillDisable(){
    return this.OomKillDisable;
    }
    public T withOomKillDisable( Boolean OomKillDisable){
    this.OomKillDisable=OomKillDisable; return (T) this;
    }
    public String getOperatingSystem(){
    return this.OperatingSystem;
    }
    public T withOperatingSystem( String OperatingSystem){
    this.OperatingSystem=OperatingSystem; return (T) this;
    }
    public ServiceConfig getRegistryConfig(){
    return this.RegistryConfig!=null?this.RegistryConfig.build():null;
    }
    public T withRegistryConfig( ServiceConfig RegistryConfig){
    if (RegistryConfig!=null){ this.RegistryConfig= new ServiceConfigBuilder(RegistryConfig); _visitables.add(this.RegistryConfig);} return (T) this;
    }
    public RegistryConfigNested<T> withNewRegistryConfig(){
    return new RegistryConfigNestedImpl<T>();
    }
    public RegistryConfigNested<T> withNewRegistryConfigLike( ServiceConfig item){
    return new RegistryConfigNestedImpl<T>(item);
    }
    public RegistryConfigNested<T> editRegistryConfig(){
    return withNewRegistryConfigLike(getRegistryConfig());
    }
    public String getServerVersion(){
    return this.ServerVersion;
    }
    public T withServerVersion( String ServerVersion){
    this.ServerVersion=ServerVersion; return (T) this;
    }
    public Boolean isSwapLimit(){
    return this.SwapLimit;
    }
    public T withSwapLimit( Boolean SwapLimit){
    this.SwapLimit=SwapLimit; return (T) this;
    }
    public String getSystemTime(){
    return this.SystemTime;
    }
    public T withSystemTime( String SystemTime){
    this.SystemTime=SystemTime; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
InfoFluentImpl that = (InfoFluentImpl) o;
if (BridgeNfIp6tables != null ? !BridgeNfIp6tables.equals(that.BridgeNfIp6tables) :that.BridgeNfIp6tables != null) return false;
if (BridgeNfIptables != null ? !BridgeNfIptables.equals(that.BridgeNfIptables) :that.BridgeNfIptables != null) return false;
if (ClusterAdvertise != null ? !ClusterAdvertise.equals(that.ClusterAdvertise) :that.ClusterAdvertise != null) return false;
if (ClusterStore != null ? !ClusterStore.equals(that.ClusterStore) :that.ClusterStore != null) return false;
if (Containers != null ? !Containers.equals(that.Containers) :that.Containers != null) return false;
if (CpuCfsPeriod != null ? !CpuCfsPeriod.equals(that.CpuCfsPeriod) :that.CpuCfsPeriod != null) return false;
if (CpuCfsQuota != null ? !CpuCfsQuota.equals(that.CpuCfsQuota) :that.CpuCfsQuota != null) return false;
if (Debug != null ? !Debug.equals(that.Debug) :that.Debug != null) return false;
if (DockerRootDir != null ? !DockerRootDir.equals(that.DockerRootDir) :that.DockerRootDir != null) return false;
if (Driver != null ? !Driver.equals(that.Driver) :that.Driver != null) return false;
if (DriverStatus != null ? !DriverStatus.equals(that.DriverStatus) :that.DriverStatus != null) return false;
if (ExecutionDriver != null ? !ExecutionDriver.equals(that.ExecutionDriver) :that.ExecutionDriver != null) return false;
if (ExperimentalBuild != null ? !ExperimentalBuild.equals(that.ExperimentalBuild) :that.ExperimentalBuild != null) return false;
if (HttpProxy != null ? !HttpProxy.equals(that.HttpProxy) :that.HttpProxy != null) return false;
if (HttpsProxy != null ? !HttpsProxy.equals(that.HttpsProxy) :that.HttpsProxy != null) return false;
if (ID != null ? !ID.equals(that.ID) :that.ID != null) return false;
if (IPv4Forwarding != null ? !IPv4Forwarding.equals(that.IPv4Forwarding) :that.IPv4Forwarding != null) return false;
if (Images != null ? !Images.equals(that.Images) :that.Images != null) return false;
if (IndexServerAddress != null ? !IndexServerAddress.equals(that.IndexServerAddress) :that.IndexServerAddress != null) return false;
if (InitPath != null ? !InitPath.equals(that.InitPath) :that.InitPath != null) return false;
if (InitSha1 != null ? !InitSha1.equals(that.InitSha1) :that.InitSha1 != null) return false;
if (KernelVersion != null ? !KernelVersion.equals(that.KernelVersion) :that.KernelVersion != null) return false;
if (Labels != null ? !Labels.equals(that.Labels) :that.Labels != null) return false;
if (LoggingDriver != null ? !LoggingDriver.equals(that.LoggingDriver) :that.LoggingDriver != null) return false;
if (MemTotal != null ? !MemTotal.equals(that.MemTotal) :that.MemTotal != null) return false;
if (MemoryLimit != null ? !MemoryLimit.equals(that.MemoryLimit) :that.MemoryLimit != null) return false;
if (NCPU != null ? !NCPU.equals(that.NCPU) :that.NCPU != null) return false;
if (NEventsListener != null ? !NEventsListener.equals(that.NEventsListener) :that.NEventsListener != null) return false;
if (NFd != null ? !NFd.equals(that.NFd) :that.NFd != null) return false;
if (NGoroutines != null ? !NGoroutines.equals(that.NGoroutines) :that.NGoroutines != null) return false;
if (Name != null ? !Name.equals(that.Name) :that.Name != null) return false;
if (NoProxy != null ? !NoProxy.equals(that.NoProxy) :that.NoProxy != null) return false;
if (OomKillDisable != null ? !OomKillDisable.equals(that.OomKillDisable) :that.OomKillDisable != null) return false;
if (OperatingSystem != null ? !OperatingSystem.equals(that.OperatingSystem) :that.OperatingSystem != null) return false;
if (RegistryConfig != null ? !RegistryConfig.equals(that.RegistryConfig) :that.RegistryConfig != null) return false;
if (ServerVersion != null ? !ServerVersion.equals(that.ServerVersion) :that.ServerVersion != null) return false;
if (SwapLimit != null ? !SwapLimit.equals(that.SwapLimit) :that.SwapLimit != null) return false;
if (SystemTime != null ? !SystemTime.equals(that.SystemTime) :that.SystemTime != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class RegistryConfigNestedImpl<N> extends ServiceConfigFluentImpl<RegistryConfigNested<N>> implements RegistryConfigNested<N>{

        private final ServiceConfigBuilder builder;
    
             RegistryConfigNestedImpl (){
        this.builder = new ServiceConfigBuilder(this);
        }
             RegistryConfigNestedImpl ( ServiceConfig item){
        this.builder = new ServiceConfigBuilder(this, item);
        }
    
            public N endRegistryConfig(){
            return and();
        }
            public N and(){
            return (N) InfoFluentImpl.this.withRegistryConfig(builder.build());
        }
    
}


}
