package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class ImageFluentImpl<T extends ImageFluent<T>> extends BaseFluent<T> implements ImageFluent<T>{

     Long Created;     String Id;     Map<String, String> Labels = new HashMap();     String ParentId;     List<String> RepoDigests = new ArrayList();     List<String> RepoTags = new ArrayList();     Long Size;     Long VirtualSize;     Map<String, Object> additionalProperties = new HashMap();
public ImageFluentImpl(){
    
}
public ImageFluentImpl( Image instance ){
    this.withCreated(instance.getCreated()); this.withId(instance.getId()); this.withLabels(instance.getLabels()); this.withParentId(instance.getParentId()); this.withRepoDigests(instance.getRepoDigests()); this.withRepoTags(instance.getRepoTags()); this.withSize(instance.getSize()); this.withVirtualSize(instance.getVirtualSize()); 
}

    public Long getCreated(){
    return this.Created;
    }
    public T withCreated( Long Created){
    this.Created=Created; return (T) this;
    }
    public String getId(){
    return this.Id;
    }
    public T withId( String Id){
    this.Id=Id; return (T) this;
    }
    public T addToLabels( String key,  String value){
    if(key != null && value != null) {this.Labels.put(key, value);} return (T)this;
    }
    public T addToLabels( Map<String, String> map){
    if(map != null) { this.Labels.putAll(map);} return (T)this;
    }
    public T removeFromLabels( String key){
    if(key != null) {this.Labels.remove(key);} return (T)this;
    }
    public T removeFromLabels( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.Labels.remove(key);}} return (T)this;
    }
    public Map<String, String> getLabels(){
    return this.Labels;
    }
    public T withLabels( Map<String, String> Labels){
    this.Labels.clear();if (Labels != null) {this.Labels.putAll(Labels);} return (T) this;
    }
    public String getParentId(){
    return this.ParentId;
    }
    public T withParentId( String ParentId){
    this.ParentId=ParentId; return (T) this;
    }
    public T addToRepoDigests( String ...items){
    for (String item : items) {this.RepoDigests.add(item);} return (T)this;
    }
    public T removeFromRepoDigests( String ...items){
    for (String item : items) {this.RepoDigests.remove(item);} return (T)this;
    }
    public List<String> getRepoDigests(){
    return this.RepoDigests;
    }
    public T withRepoDigests( List<String> RepoDigests){
    this.RepoDigests.clear();if (RepoDigests != null) {for (String item : RepoDigests){this.addToRepoDigests(item);}} return (T) this;
    }
    public T withRepoDigests( String ...RepoDigests){
    this.RepoDigests.clear(); if (RepoDigests != null) {for (String item :RepoDigests){ this.addToRepoDigests(item);}} return (T) this;
    }
    public T addToRepoTags( String ...items){
    for (String item : items) {this.RepoTags.add(item);} return (T)this;
    }
    public T removeFromRepoTags( String ...items){
    for (String item : items) {this.RepoTags.remove(item);} return (T)this;
    }
    public List<String> getRepoTags(){
    return this.RepoTags;
    }
    public T withRepoTags( List<String> RepoTags){
    this.RepoTags.clear();if (RepoTags != null) {for (String item : RepoTags){this.addToRepoTags(item);}} return (T) this;
    }
    public T withRepoTags( String ...RepoTags){
    this.RepoTags.clear(); if (RepoTags != null) {for (String item :RepoTags){ this.addToRepoTags(item);}} return (T) this;
    }
    public Long getSize(){
    return this.Size;
    }
    public T withSize( Long Size){
    this.Size=Size; return (T) this;
    }
    public Long getVirtualSize(){
    return this.VirtualSize;
    }
    public T withVirtualSize( Long VirtualSize){
    this.VirtualSize=VirtualSize; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageFluentImpl that = (ImageFluentImpl) o;
if (Created != null ? !Created.equals(that.Created) :that.Created != null) return false;
if (Id != null ? !Id.equals(that.Id) :that.Id != null) return false;
if (Labels != null ? !Labels.equals(that.Labels) :that.Labels != null) return false;
if (ParentId != null ? !ParentId.equals(that.ParentId) :that.ParentId != null) return false;
if (RepoDigests != null ? !RepoDigests.equals(that.RepoDigests) :that.RepoDigests != null) return false;
if (RepoTags != null ? !RepoTags.equals(that.RepoTags) :that.RepoTags != null) return false;
if (Size != null ? !Size.equals(that.Size) :that.Size != null) return false;
if (VirtualSize != null ? !VirtualSize.equals(that.VirtualSize) :that.VirtualSize != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
