package io.fabric8.docker.api.model;

import java.util.Map;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;

public class ContainerCreateRequestFluentImpl<T extends ContainerCreateRequestFluent<T>> extends BaseFluent<T> implements ContainerCreateRequestFluent<T>{

     String hostname;     String domainname;     String user;     String memory;     String memorySwap;     String memoryReservation;     String kernelMemory;     String cpuShares;     String cpuPeriod;     String cpuQuota;     String cpuset;     String cpusetCpus;     String cpusetMems;     Integer blkioWeight;     Integer memorySwappiness;     Boolean oomKillDisable;     Boolean attachStdin;     Boolean attachStdout;     Boolean attachStderr;     Boolean tty;     Boolean openStdin;     Boolean stdinOnce;     Map<String, String> env = new HashMap();     List<String> cmd = new ArrayList();     String entrypoint;     String image;     Map<String, String> labels = new HashMap();     Map<String, String> mounts = new HashMap();     String workingDir;     Boolean networkDisabled;     String macAddress;     Map<Integer, Protocol> exposedPorts = new HashMap();     String stopSignal;     VisitableBuilder<HostConfig, ?> hostConfig;
public ContainerCreateRequestFluentImpl(){
    
}
public ContainerCreateRequestFluentImpl( ContainerCreateRequest instance ){
    this.withCpuset(instance.getCpuset()); this.withHostname(instance.getHostname()); this.withDomainname(instance.getDomainname()); this.withUser(instance.getUser()); this.withMemory(instance.getMemory()); this.withMemorySwap(instance.getMemorySwap()); this.withMemoryReservation(instance.getMemoryReservation()); this.withKernelMemory(instance.getKernelMemory()); this.withCpuShares(instance.getCpuShares()); this.withCpuPeriod(instance.getCpuPeriod()); this.withCpuQuota(instance.getCpuQuota()); this.withCpusetCpus(instance.getCpusetCpus()); this.withCpusetMems(instance.getCpusetMems()); this.withBlkioWeight(instance.getBlkioWeight()); this.withMemorySwappiness(instance.getMemorySwappiness()); this.withOomKillDisable(instance.getOomKillDisable()); this.withAttachStdin(instance.getAttachStdin()); this.withAttachStdout(instance.getAttachStdout()); this.withAttachStderr(instance.getAttachStderr()); this.withTty(instance.getTty()); this.withOpenStdin(instance.getOpenStdin()); this.withStdinOnce(instance.getStdinOnce()); this.withEnv(instance.getEnv()); this.withCmd(instance.getCmd()); this.withEntrypoint(instance.getEntrypoint()); this.withImage(instance.getImage()); this.withLabels(instance.getLabels()); this.withMounts(instance.getMounts()); this.withWorkingDir(instance.getWorkingDir()); this.withNetworkDisabled(instance.getNetworkDisabled()); this.withMacAddress(instance.getMacAddress()); this.withExposedPorts(instance.getExposedPorts()); this.withStopSignal(instance.getStopSignal()); this.withHostConfig(instance.getHostConfig()); 
}

    public String getHostname(){
    return this.hostname;
    }
    public T withHostname( String hostname){
    this.hostname=hostname; return (T) this;
    }
    public String getDomainname(){
    return this.domainname;
    }
    public T withDomainname( String domainname){
    this.domainname=domainname; return (T) this;
    }
    public String getUser(){
    return this.user;
    }
    public T withUser( String user){
    this.user=user; return (T) this;
    }
    public String getMemory(){
    return this.memory;
    }
    public T withMemory( String memory){
    this.memory=memory; return (T) this;
    }
    public String getMemorySwap(){
    return this.memorySwap;
    }
    public T withMemorySwap( String memorySwap){
    this.memorySwap=memorySwap; return (T) this;
    }
    public String getMemoryReservation(){
    return this.memoryReservation;
    }
    public T withMemoryReservation( String memoryReservation){
    this.memoryReservation=memoryReservation; return (T) this;
    }
    public String getKernelMemory(){
    return this.kernelMemory;
    }
    public T withKernelMemory( String kernelMemory){
    this.kernelMemory=kernelMemory; return (T) this;
    }
    public String getCpuShares(){
    return this.cpuShares;
    }
    public T withCpuShares( String cpuShares){
    this.cpuShares=cpuShares; return (T) this;
    }
    public String getCpuPeriod(){
    return this.cpuPeriod;
    }
    public T withCpuPeriod( String cpuPeriod){
    this.cpuPeriod=cpuPeriod; return (T) this;
    }
    public String getCpuQuota(){
    return this.cpuQuota;
    }
    public T withCpuQuota( String cpuQuota){
    this.cpuQuota=cpuQuota; return (T) this;
    }
    public String getCpuset(){
    return this.cpuset;
    }
    public T withCpuset( String cpuset){
    this.cpuset=cpuset; return (T) this;
    }
    public String getCpusetCpus(){
    return this.cpusetCpus;
    }
    public T withCpusetCpus( String cpusetCpus){
    this.cpusetCpus=cpusetCpus; return (T) this;
    }
    public String getCpusetMems(){
    return this.cpusetMems;
    }
    public T withCpusetMems( String cpusetMems){
    this.cpusetMems=cpusetMems; return (T) this;
    }
    public Integer getBlkioWeight(){
    return this.blkioWeight;
    }
    public T withBlkioWeight( Integer blkioWeight){
    this.blkioWeight=blkioWeight; return (T) this;
    }
    public Integer getMemorySwappiness(){
    return this.memorySwappiness;
    }
    public T withMemorySwappiness( Integer memorySwappiness){
    this.memorySwappiness=memorySwappiness; return (T) this;
    }
    public Boolean isOomKillDisable(){
    return this.oomKillDisable;
    }
    public T withOomKillDisable( Boolean oomKillDisable){
    this.oomKillDisable=oomKillDisable; return (T) this;
    }
    public Boolean isAttachStdin(){
    return this.attachStdin;
    }
    public T withAttachStdin( Boolean attachStdin){
    this.attachStdin=attachStdin; return (T) this;
    }
    public Boolean isAttachStdout(){
    return this.attachStdout;
    }
    public T withAttachStdout( Boolean attachStdout){
    this.attachStdout=attachStdout; return (T) this;
    }
    public Boolean isAttachStderr(){
    return this.attachStderr;
    }
    public T withAttachStderr( Boolean attachStderr){
    this.attachStderr=attachStderr; return (T) this;
    }
    public Boolean isTty(){
    return this.tty;
    }
    public T withTty( Boolean tty){
    this.tty=tty; return (T) this;
    }
    public Boolean isOpenStdin(){
    return this.openStdin;
    }
    public T withOpenStdin( Boolean openStdin){
    this.openStdin=openStdin; return (T) this;
    }
    public Boolean isStdinOnce(){
    return this.stdinOnce;
    }
    public T withStdinOnce( Boolean stdinOnce){
    this.stdinOnce=stdinOnce; return (T) this;
    }
    public T addToEnv( String key,  String value){
    if(key != null && value != null) {this.env.put(key, value);} return (T)this;
    }
    public T addToEnv( Map<String, String> map){
    if(map != null) { this.env.putAll(map);} return (T)this;
    }
    public T removeFromEnv( String key){
    if(key != null) {this.env.remove(key);} return (T)this;
    }
    public T removeFromEnv( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.env.remove(key);}} return (T)this;
    }
    public Map<String, String> getEnv(){
    return this.env;
    }
    public T withEnv( Map<String, String> env){
    this.env.clear();if (env != null) {this.env.putAll(env);} return (T) this;
    }
    public T addToCmd( String ...items){
    for (String item : items) {this.cmd.add(item);} return (T)this;
    }
    public T removeFromCmd( String ...items){
    for (String item : items) {this.cmd.remove(item);} return (T)this;
    }
    public List<String> getCmd(){
    return this.cmd;
    }
    public T withCmd( List<String> cmd){
    this.cmd.clear();if (cmd != null) {for (String item : cmd){this.addToCmd(item);}} return (T) this;
    }
    public T withCmd( String ...cmd){
    this.cmd.clear(); if (cmd != null) {for (String item :cmd){ this.addToCmd(item);}} return (T) this;
    }
    public String getEntrypoint(){
    return this.entrypoint;
    }
    public T withEntrypoint( String entrypoint){
    this.entrypoint=entrypoint; return (T) this;
    }
    public String getImage(){
    return this.image;
    }
    public T withImage( String image){
    this.image=image; return (T) this;
    }
    public T addToLabels( String key,  String value){
    if(key != null && value != null) {this.labels.put(key, value);} return (T)this;
    }
    public T addToLabels( Map<String, String> map){
    if(map != null) { this.labels.putAll(map);} return (T)this;
    }
    public T removeFromLabels( String key){
    if(key != null) {this.labels.remove(key);} return (T)this;
    }
    public T removeFromLabels( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.labels.remove(key);}} return (T)this;
    }
    public Map<String, String> getLabels(){
    return this.labels;
    }
    public T withLabels( Map<String, String> labels){
    this.labels.clear();if (labels != null) {this.labels.putAll(labels);} return (T) this;
    }
    public T addToMounts( String key,  String value){
    if(key != null && value != null) {this.mounts.put(key, value);} return (T)this;
    }
    public T addToMounts( Map<String, String> map){
    if(map != null) { this.mounts.putAll(map);} return (T)this;
    }
    public T removeFromMounts( String key){
    if(key != null) {this.mounts.remove(key);} return (T)this;
    }
    public T removeFromMounts( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.mounts.remove(key);}} return (T)this;
    }
    public Map<String, String> getMounts(){
    return this.mounts;
    }
    public T withMounts( Map<String, String> mounts){
    this.mounts.clear();if (mounts != null) {this.mounts.putAll(mounts);} return (T) this;
    }
    public String getWorkingDir(){
    return this.workingDir;
    }
    public T withWorkingDir( String workingDir){
    this.workingDir=workingDir; return (T) this;
    }
    public Boolean isNetworkDisabled(){
    return this.networkDisabled;
    }
    public T withNetworkDisabled( Boolean networkDisabled){
    this.networkDisabled=networkDisabled; return (T) this;
    }
    public String getMacAddress(){
    return this.macAddress;
    }
    public T withMacAddress( String macAddress){
    this.macAddress=macAddress; return (T) this;
    }
    public T addToExposedPorts( Integer key,  Protocol value){
    if(key != null && value != null) {this.exposedPorts.put(key, value);} return (T)this;
    }
    public T addToExposedPorts( Map<Integer, Protocol> map){
    if(map != null) { this.exposedPorts.putAll(map);} return (T)this;
    }
    public T removeFromExposedPorts( Integer key){
    if(key != null) {this.exposedPorts.remove(key);} return (T)this;
    }
    public T removeFromExposedPorts( Map<Integer, Protocol> map){
    if(map != null) { for(Object key : map.keySet()) {this.exposedPorts.remove(key);}} return (T)this;
    }
    public Map<Integer, Protocol> getExposedPorts(){
    return this.exposedPorts;
    }
    public T withExposedPorts( Map<Integer, Protocol> exposedPorts){
    this.exposedPorts.clear();if (exposedPorts != null) {this.exposedPorts.putAll(exposedPorts);} return (T) this;
    }
    public String getStopSignal(){
    return this.stopSignal;
    }
    public T withStopSignal( String stopSignal){
    this.stopSignal=stopSignal; return (T) this;
    }
    public HostConfig getHostConfig(){
    return this.hostConfig!=null?this.hostConfig.build():null;
    }
    public T withHostConfig( HostConfig hostConfig){
    if (hostConfig!=null){ this.hostConfig= new HostConfigBuilder(hostConfig); _visitables.add(this.hostConfig);} return (T) this;
    }
    public HostConfigNested<T> withNewHostConfig(){
    return new HostConfigNestedImpl<T>();
    }
    public HostConfigNested<T> withNewHostConfigLike( HostConfig item){
    return new HostConfigNestedImpl<T>(item);
    }
    public HostConfigNested<T> editHostConfig(){
    return withNewHostConfigLike(getHostConfig());
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerCreateRequestFluentImpl that = (ContainerCreateRequestFluentImpl) o;
if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
if (domainname != null ? !domainname.equals(that.domainname) :that.domainname != null) return false;
if (user != null ? !user.equals(that.user) :that.user != null) return false;
if (memory != null ? !memory.equals(that.memory) :that.memory != null) return false;
if (memorySwap != null ? !memorySwap.equals(that.memorySwap) :that.memorySwap != null) return false;
if (memoryReservation != null ? !memoryReservation.equals(that.memoryReservation) :that.memoryReservation != null) return false;
if (kernelMemory != null ? !kernelMemory.equals(that.kernelMemory) :that.kernelMemory != null) return false;
if (cpuShares != null ? !cpuShares.equals(that.cpuShares) :that.cpuShares != null) return false;
if (cpuPeriod != null ? !cpuPeriod.equals(that.cpuPeriod) :that.cpuPeriod != null) return false;
if (cpuQuota != null ? !cpuQuota.equals(that.cpuQuota) :that.cpuQuota != null) return false;
if (cpuset != null ? !cpuset.equals(that.cpuset) :that.cpuset != null) return false;
if (cpusetCpus != null ? !cpusetCpus.equals(that.cpusetCpus) :that.cpusetCpus != null) return false;
if (cpusetMems != null ? !cpusetMems.equals(that.cpusetMems) :that.cpusetMems != null) return false;
if (blkioWeight != null ? !blkioWeight.equals(that.blkioWeight) :that.blkioWeight != null) return false;
if (memorySwappiness != null ? !memorySwappiness.equals(that.memorySwappiness) :that.memorySwappiness != null) return false;
if (oomKillDisable != null ? !oomKillDisable.equals(that.oomKillDisable) :that.oomKillDisable != null) return false;
if (attachStdin != null ? !attachStdin.equals(that.attachStdin) :that.attachStdin != null) return false;
if (attachStdout != null ? !attachStdout.equals(that.attachStdout) :that.attachStdout != null) return false;
if (attachStderr != null ? !attachStderr.equals(that.attachStderr) :that.attachStderr != null) return false;
if (tty != null ? !tty.equals(that.tty) :that.tty != null) return false;
if (openStdin != null ? !openStdin.equals(that.openStdin) :that.openStdin != null) return false;
if (stdinOnce != null ? !stdinOnce.equals(that.stdinOnce) :that.stdinOnce != null) return false;
if (env != null ? !env.equals(that.env) :that.env != null) return false;
if (cmd != null ? !cmd.equals(that.cmd) :that.cmd != null) return false;
if (entrypoint != null ? !entrypoint.equals(that.entrypoint) :that.entrypoint != null) return false;
if (image != null ? !image.equals(that.image) :that.image != null) return false;
if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
if (mounts != null ? !mounts.equals(that.mounts) :that.mounts != null) return false;
if (workingDir != null ? !workingDir.equals(that.workingDir) :that.workingDir != null) return false;
if (networkDisabled != null ? !networkDisabled.equals(that.networkDisabled) :that.networkDisabled != null) return false;
if (macAddress != null ? !macAddress.equals(that.macAddress) :that.macAddress != null) return false;
if (exposedPorts != null ? !exposedPorts.equals(that.exposedPorts) :that.exposedPorts != null) return false;
if (stopSignal != null ? !stopSignal.equals(that.stopSignal) :that.stopSignal != null) return false;
if (hostConfig != null ? !hostConfig.equals(that.hostConfig) :that.hostConfig != null) return false;
return true;

    }

    public class HostConfigNestedImpl<N> extends HostConfigFluentImpl<HostConfigNested<N>> implements HostConfigNested<N>{

        private final HostConfigBuilder builder;
    
             HostConfigNestedImpl (){
        this.builder = new HostConfigBuilder(this);
        }
             HostConfigNestedImpl ( HostConfig item){
        this.builder = new HostConfigBuilder(this, item);
        }
    
            public N and(){
            return (N) ContainerCreateRequestFluentImpl.this.withHostConfig(builder.build());
        }
            public N endHostConfig(){
            return and();
        }
    
}


}
