package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class CPUUsageFluentImpl<T extends CPUUsageFluent<T>> extends BaseFluent<T> implements CPUUsageFluent<T>{

     List<Long> percpuUsage = new ArrayList();     Long totalUsage;     Long usageInKernelmode;     Long usageInUsermode;     Map<String, Object> additionalProperties = new HashMap();
public CPUUsageFluentImpl(){
    
}
public CPUUsageFluentImpl( CPUUsage instance ){
    this.withPercpuUsage(instance.getPercpuUsage()); this.withTotalUsage(instance.getTotalUsage()); this.withUsageInKernelmode(instance.getUsageInKernelmode()); this.withUsageInUsermode(instance.getUsageInUsermode()); 
}

    public T addToPercpuUsage( Long ...items){
    for (Long item : items) {this.percpuUsage.add(item);} return (T)this;
    }
    public T removeFromPercpuUsage( Long ...items){
    for (Long item : items) {this.percpuUsage.remove(item);} return (T)this;
    }
    public List<Long> getPercpuUsage(){
    return this.percpuUsage;
    }
    public T withPercpuUsage( List<Long> percpuUsage){
    this.percpuUsage.clear();if (percpuUsage != null) {for (Long item : percpuUsage){this.addToPercpuUsage(item);}} return (T) this;
    }
    public T withPercpuUsage( Long ...percpuUsage){
    this.percpuUsage.clear(); if (percpuUsage != null) {for (Long item :percpuUsage){ this.addToPercpuUsage(item);}} return (T) this;
    }
    public Long getTotalUsage(){
    return this.totalUsage;
    }
    public T withTotalUsage( Long totalUsage){
    this.totalUsage=totalUsage; return (T) this;
    }
    public Long getUsageInKernelmode(){
    return this.usageInKernelmode;
    }
    public T withUsageInKernelmode( Long usageInKernelmode){
    this.usageInKernelmode=usageInKernelmode; return (T) this;
    }
    public Long getUsageInUsermode(){
    return this.usageInUsermode;
    }
    public T withUsageInUsermode( Long usageInUsermode){
    this.usageInUsermode=usageInUsermode; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
CPUUsageFluentImpl that = (CPUUsageFluentImpl) o;
if (percpuUsage != null ? !percpuUsage.equals(that.percpuUsage) :that.percpuUsage != null) return false;
if (totalUsage != null ? !totalUsage.equals(that.totalUsage) :that.totalUsage != null) return false;
if (usageInKernelmode != null ? !usageInKernelmode.equals(that.usageInKernelmode) :that.usageInKernelmode != null) return false;
if (usageInUsermode != null ? !usageInUsermode.equals(that.usageInUsermode) :that.usageInUsermode != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
