package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class BlkioStatsBuilder extends BlkioStatsFluentImpl<BlkioStatsBuilder> implements VisitableBuilder<BlkioStats,BlkioStatsBuilder>{

     BlkioStatsFluent<?> fluent;
public BlkioStatsBuilder(){
    this(new BlkioStats());
}
public BlkioStatsBuilder( BlkioStatsFluent<?> fluent ){
    this(fluent, new BlkioStats());
}
public BlkioStatsBuilder( BlkioStatsFluent<?> fluent , BlkioStats instance ){
    this.fluent = fluent; fluent.withIoMergedRecursive(instance.getIoMergedRecursive()); fluent.withIoQueueRecursive(instance.getIoQueueRecursive()); fluent.withIoServiceBytesRecursive(instance.getIoServiceBytesRecursive()); fluent.withIoServiceTimeRecursive(instance.getIoServiceTimeRecursive()); fluent.withIoServicedRecursive(instance.getIoServicedRecursive()); fluent.withIoTimeRecursive(instance.getIoTimeRecursive()); fluent.withIoWaitTimeRecursive(instance.getIoWaitTimeRecursive()); fluent.withSectorsRecursive(instance.getSectorsRecursive()); 
}
public BlkioStatsBuilder( BlkioStats instance ){
    this.fluent = this; this.withIoMergedRecursive(instance.getIoMergedRecursive()); this.withIoQueueRecursive(instance.getIoQueueRecursive()); this.withIoServiceBytesRecursive(instance.getIoServiceBytesRecursive()); this.withIoServiceTimeRecursive(instance.getIoServiceTimeRecursive()); this.withIoServicedRecursive(instance.getIoServicedRecursive()); this.withIoTimeRecursive(instance.getIoTimeRecursive()); this.withIoWaitTimeRecursive(instance.getIoWaitTimeRecursive()); this.withSectorsRecursive(instance.getSectorsRecursive()); 
}

public EditableBlkioStats build(){
    EditableBlkioStats buildable = new EditableBlkioStats(fluent.getIoMergedRecursive(),fluent.getIoQueueRecursive(),fluent.getIoServiceBytesRecursive(),fluent.getIoServiceTimeRecursive(),fluent.getIoServicedRecursive(),fluent.getIoTimeRecursive(),fluent.getIoWaitTimeRecursive(),fluent.getSectorsRecursive());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
BlkioStatsBuilder that = (BlkioStatsBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
