package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class AuthConfigBuilder extends AuthConfigFluentImpl<AuthConfigBuilder> implements VisitableBuilder<AuthConfig,AuthConfigBuilder>{

     AuthConfigFluent<?> fluent;
public AuthConfigBuilder(){
    this(new AuthConfig());
}
public AuthConfigBuilder( AuthConfigFluent<?> fluent ){
    this(fluent, new AuthConfig());
}
public AuthConfigBuilder( AuthConfigFluent<?> fluent , AuthConfig instance ){
    this.fluent = fluent; fluent.withAuth(instance.getAuth()); fluent.withEmail(instance.getEmail()); fluent.withPassword(instance.getPassword()); fluent.withServeraddress(instance.getServeraddress()); fluent.withUsername(instance.getUsername()); 
}
public AuthConfigBuilder( AuthConfig instance ){
    this.fluent = this; this.withAuth(instance.getAuth()); this.withEmail(instance.getEmail()); this.withPassword(instance.getPassword()); this.withServeraddress(instance.getServeraddress()); this.withUsername(instance.getUsername()); 
}

public EditableAuthConfig build(){
    EditableAuthConfig buildable = new EditableAuthConfig(fluent.getAuth(),fluent.getEmail(),fluent.getPassword(),fluent.getServeraddress(),fluent.getUsername());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
AuthConfigBuilder that = (AuthConfigBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
