/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableStats;
import io.fabric8.docker.api.model.Stats;
import io.fabric8.docker.api.model.StatsFluent;
import io.fabric8.docker.api.model.StatsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class StatsBuilder
extends StatsFluentImpl<StatsBuilder>
implements VisitableBuilder<Stats, StatsBuilder> {
    StatsFluent<?> fluent;

    public StatsBuilder() {
        this(new Stats());
    }

    public StatsBuilder(StatsFluent<?> fluent) {
        this(fluent, new Stats());
    }

    public StatsBuilder(StatsFluent<?> fluent, Stats instance) {
        this.fluent = fluent;
        fluent.withBlkioStats(instance.getBlkioStats());
        fluent.withCpuStats(instance.getCpuStats());
        fluent.withMemoryStats(instance.getMemoryStats());
        fluent.withPrecpuStats(instance.getPrecpuStats());
        fluent.withRead(instance.getRead());
    }

    public StatsBuilder(Stats instance) {
        this.fluent = this;
        this.withBlkioStats(instance.getBlkioStats());
        this.withCpuStats(instance.getCpuStats());
        this.withMemoryStats(instance.getMemoryStats());
        this.withPrecpuStats(instance.getPrecpuStats());
        this.withRead(instance.getRead());
    }

    @Override
    public EditableStats build() {
        EditableStats buildable = new EditableStats(this.fluent.getBlkioStats(), this.fluent.getCpuStats(), this.fluent.getMemoryStats(), this.fluent.getPrecpuStats(), this.fluent.getRead());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StatsBuilder that = (StatsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

