/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableSearchResults;
import io.fabric8.docker.api.model.SearchResults;
import io.fabric8.docker.api.model.SearchResultsFluent;
import io.fabric8.docker.api.model.SearchResultsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class SearchResultsBuilder
extends SearchResultsFluentImpl<SearchResultsBuilder>
implements VisitableBuilder<SearchResults, SearchResultsBuilder> {
    SearchResultsFluent<?> fluent;

    public SearchResultsBuilder() {
        this(new SearchResults());
    }

    public SearchResultsBuilder(SearchResultsFluent<?> fluent) {
        this(fluent, new SearchResults());
    }

    public SearchResultsBuilder(SearchResultsFluent<?> fluent, SearchResults instance) {
        this.fluent = fluent;
        fluent.withNumResults(instance.getNumResults());
        fluent.withQuery(instance.getQuery());
        fluent.withResults(instance.getResults());
    }

    public SearchResultsBuilder(SearchResults instance) {
        this.fluent = this;
        this.withNumResults(instance.getNumResults());
        this.withQuery(instance.getQuery());
        this.withResults(instance.getResults());
    }

    @Override
    public EditableSearchResults build() {
        EditableSearchResults buildable = new EditableSearchResults(this.fluent.getNumResults(), this.fluent.getQuery(), this.fluent.getResults());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SearchResultsBuilder that = (SearchResultsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

