/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.Address;
import io.fabric8.docker.api.model.AddressBuilder;
import io.fabric8.docker.api.model.AddressFluentImpl;
import io.fabric8.docker.api.model.NetworkSettingsBase;
import io.fabric8.docker.api.model.NetworkSettingsBaseFluent;
import io.fabric8.docker.api.model.PortBinding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetworkSettingsBaseFluentImpl<T extends NetworkSettingsBaseFluent<T>>
extends BaseFluent<T>
implements NetworkSettingsBaseFluent<T> {
    String Bridge;
    Boolean HairpinMode;
    String LinkLocalIPv6Address;
    Integer LinkLocalIPv6PrefixLen;
    Map<String, ArrayList<PortBinding>> Ports = new HashMap<String, ArrayList<PortBinding>>();
    String SandboxID;
    String SandboxKey;
    List<VisitableBuilder<Address, ?>> SecondaryIPAddresses = new ArrayList();
    List<VisitableBuilder<Address, ?>> SecondaryIPv6Addresses = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public NetworkSettingsBaseFluentImpl() {
    }

    public NetworkSettingsBaseFluentImpl(NetworkSettingsBase instance) {
        this.withBridge(instance.getBridge());
        this.withHairpinMode(instance.getHairpinMode());
        this.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address());
        this.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen());
        this.withPorts(instance.getPorts());
        this.withSandboxID(instance.getSandboxID());
        this.withSandboxKey(instance.getSandboxKey());
        this.withSecondaryIPAddresses(instance.getSecondaryIPAddresses());
        this.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses());
    }

    @Override
    public String getBridge() {
        return this.Bridge;
    }

    @Override
    public T withBridge(String Bridge) {
        this.Bridge = Bridge;
        return (T)this;
    }

    @Override
    public Boolean isHairpinMode() {
        return this.HairpinMode;
    }

    @Override
    public T withHairpinMode(Boolean HairpinMode) {
        this.HairpinMode = HairpinMode;
        return (T)this;
    }

    @Override
    public String getLinkLocalIPv6Address() {
        return this.LinkLocalIPv6Address;
    }

    @Override
    public T withLinkLocalIPv6Address(String LinkLocalIPv6Address) {
        this.LinkLocalIPv6Address = LinkLocalIPv6Address;
        return (T)this;
    }

    @Override
    public Integer getLinkLocalIPv6PrefixLen() {
        return this.LinkLocalIPv6PrefixLen;
    }

    @Override
    public T withLinkLocalIPv6PrefixLen(Integer LinkLocalIPv6PrefixLen) {
        this.LinkLocalIPv6PrefixLen = LinkLocalIPv6PrefixLen;
        return (T)this;
    }

    @Override
    public T addToPorts(String key, ArrayList<PortBinding> value) {
        if (key != null && value != null) {
            this.Ports.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToPorts(Map<String, ArrayList<PortBinding>> map) {
        if (map != null) {
            this.Ports.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromPorts(String key) {
        if (key != null) {
            this.Ports.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromPorts(Map<String, ArrayList<PortBinding>> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.Ports.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, ArrayList<PortBinding>> getPorts() {
        return this.Ports;
    }

    @Override
    public T withPorts(Map<String, ArrayList<PortBinding>> Ports) {
        this.Ports.clear();
        if (Ports != null) {
            this.Ports.putAll(Ports);
        }
        return (T)this;
    }

    @Override
    public String getSandboxID() {
        return this.SandboxID;
    }

    @Override
    public T withSandboxID(String SandboxID) {
        this.SandboxID = SandboxID;
        return (T)this;
    }

    @Override
    public String getSandboxKey() {
        return this.SandboxKey;
    }

    @Override
    public T withSandboxKey(String SandboxKey) {
        this.SandboxKey = SandboxKey;
        return (T)this;
    }

    @Override
    public T addToSecondaryIPAddresses(Address ... items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.add(builder);
            this.SecondaryIPAddresses.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromSecondaryIPAddresses(Address ... items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.remove(builder);
            this.SecondaryIPAddresses.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<Address> getSecondaryIPAddresses() {
        return this.build(this.SecondaryIPAddresses);
    }

    @Override
    public T withSecondaryIPAddresses(List<Address> SecondaryIPAddresses) {
        this.SecondaryIPAddresses.clear();
        if (SecondaryIPAddresses != null) {
            for (Address item : SecondaryIPAddresses) {
                this.addToSecondaryIPAddresses(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withSecondaryIPAddresses(Address ... SecondaryIPAddresses) {
        this.SecondaryIPAddresses.clear();
        if (SecondaryIPAddresses != null) {
            for (Address item : SecondaryIPAddresses) {
                this.addToSecondaryIPAddresses(item);
            }
        }
        return (T)this;
    }

    @Override
    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<T> addNewSecondaryIPAddresse() {
        return new SecondaryIPAddressesNestedImpl();
    }

    @Override
    public NetworkSettingsBaseFluent.SecondaryIPAddressesNested<T> addNewSecondaryIPAddresseLike(Address item) {
        return new SecondaryIPAddressesNestedImpl(item);
    }

    @Override
    public T addNewSecondaryIPAddresse(String Addr, Integer PrefixLen) {
        return this.addToSecondaryIPAddresses(new Address(Addr, PrefixLen));
    }

    @Override
    public T addToSecondaryIPv6Addresses(Address ... items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.add(builder);
            this.SecondaryIPv6Addresses.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromSecondaryIPv6Addresses(Address ... items) {
        for (Address item : items) {
            AddressBuilder builder = new AddressBuilder(item);
            this._visitables.remove(builder);
            this.SecondaryIPv6Addresses.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<Address> getSecondaryIPv6Addresses() {
        return this.build(this.SecondaryIPv6Addresses);
    }

    @Override
    public T withSecondaryIPv6Addresses(List<Address> SecondaryIPv6Addresses) {
        this.SecondaryIPv6Addresses.clear();
        if (SecondaryIPv6Addresses != null) {
            for (Address item : SecondaryIPv6Addresses) {
                this.addToSecondaryIPv6Addresses(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withSecondaryIPv6Addresses(Address ... SecondaryIPv6Addresses) {
        this.SecondaryIPv6Addresses.clear();
        if (SecondaryIPv6Addresses != null) {
            for (Address item : SecondaryIPv6Addresses) {
                this.addToSecondaryIPv6Addresses(item);
            }
        }
        return (T)this;
    }

    @Override
    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<T> addNewSecondaryIPv6Addresse() {
        return new SecondaryIPv6AddressesNestedImpl();
    }

    @Override
    public NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<T> addNewSecondaryIPv6AddresseLike(Address item) {
        return new SecondaryIPv6AddressesNestedImpl(item);
    }

    @Override
    public T addNewSecondaryIPv6Addresse(String Addr, Integer PrefixLen) {
        return this.addToSecondaryIPv6Addresses(new Address(Addr, PrefixLen));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkSettingsBaseFluentImpl that = (NetworkSettingsBaseFluentImpl)o;
        if (this.Bridge != null ? !this.Bridge.equals(that.Bridge) : that.Bridge != null) {
            return false;
        }
        if (this.HairpinMode != null ? !this.HairpinMode.equals(that.HairpinMode) : that.HairpinMode != null) {
            return false;
        }
        if (this.LinkLocalIPv6Address != null ? !this.LinkLocalIPv6Address.equals(that.LinkLocalIPv6Address) : that.LinkLocalIPv6Address != null) {
            return false;
        }
        if (this.LinkLocalIPv6PrefixLen != null ? !this.LinkLocalIPv6PrefixLen.equals(that.LinkLocalIPv6PrefixLen) : that.LinkLocalIPv6PrefixLen != null) {
            return false;
        }
        if (this.Ports != null ? !this.Ports.equals(that.Ports) : that.Ports != null) {
            return false;
        }
        if (this.SandboxID != null ? !this.SandboxID.equals(that.SandboxID) : that.SandboxID != null) {
            return false;
        }
        if (this.SandboxKey != null ? !this.SandboxKey.equals(that.SandboxKey) : that.SandboxKey != null) {
            return false;
        }
        if (this.SecondaryIPAddresses != null ? !this.SecondaryIPAddresses.equals(that.SecondaryIPAddresses) : that.SecondaryIPAddresses != null) {
            return false;
        }
        if (this.SecondaryIPv6Addresses != null ? !this.SecondaryIPv6Addresses.equals(that.SecondaryIPv6Addresses) : that.SecondaryIPv6Addresses != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class SecondaryIPv6AddressesNestedImpl<N>
    extends AddressFluentImpl<NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<N>>
    implements NetworkSettingsBaseFluent.SecondaryIPv6AddressesNested<N> {
        private final AddressBuilder builder;

        SecondaryIPv6AddressesNestedImpl() {
            this.builder = new AddressBuilder(this);
        }

        SecondaryIPv6AddressesNestedImpl(Address item) {
            this.builder = new AddressBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)NetworkSettingsBaseFluentImpl.this.addToSecondaryIPv6Addresses(this.builder.build());
        }

        @Override
        public N endSecondaryIPv6Addresse() {
            return this.and();
        }
    }

    public class SecondaryIPAddressesNestedImpl<N>
    extends AddressFluentImpl<NetworkSettingsBaseFluent.SecondaryIPAddressesNested<N>>
    implements NetworkSettingsBaseFluent.SecondaryIPAddressesNested<N> {
        private final AddressBuilder builder;

        SecondaryIPAddressesNestedImpl() {
            this.builder = new AddressBuilder(this);
        }

        SecondaryIPAddressesNestedImpl(Address item) {
            this.builder = new AddressBuilder(this, item);
        }

        @Override
        public N endSecondaryIPAddresse() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)NetworkSettingsBaseFluentImpl.this.addToSecondaryIPAddresses(this.builder.build());
        }
    }
}

