/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableGraphDriverData;
import io.fabric8.docker.api.model.GraphDriverData;
import io.fabric8.docker.api.model.GraphDriverDataFluent;
import io.fabric8.docker.api.model.GraphDriverDataFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class GraphDriverDataBuilder
extends GraphDriverDataFluentImpl<GraphDriverDataBuilder>
implements VisitableBuilder<GraphDriverData, GraphDriverDataBuilder> {
    GraphDriverDataFluent<?> fluent;

    public GraphDriverDataBuilder() {
        this(new GraphDriverData());
    }

    public GraphDriverDataBuilder(GraphDriverDataFluent<?> fluent) {
        this(fluent, new GraphDriverData());
    }

    public GraphDriverDataBuilder(GraphDriverDataFluent<?> fluent, GraphDriverData instance) {
        this.fluent = fluent;
        fluent.withData(instance.getData());
        fluent.withName(instance.getName());
    }

    public GraphDriverDataBuilder(GraphDriverData instance) {
        this.fluent = this;
        this.withData(instance.getData());
        this.withName(instance.getName());
    }

    @Override
    public EditableGraphDriverData build() {
        EditableGraphDriverData buildable = new EditableGraphDriverData(this.fluent.getData(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GraphDriverDataBuilder that = (GraphDriverDataBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

