/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableExecConfig;
import io.fabric8.docker.api.model.ExecConfig;
import io.fabric8.docker.api.model.ExecConfigFluent;
import io.fabric8.docker.api.model.ExecConfigFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ExecConfigBuilder
extends ExecConfigFluentImpl<ExecConfigBuilder>
implements VisitableBuilder<ExecConfig, ExecConfigBuilder> {
    ExecConfigFluent<?> fluent;

    public ExecConfigBuilder() {
        this(new ExecConfig());
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent) {
        this(fluent, new ExecConfig());
    }

    public ExecConfigBuilder(ExecConfigFluent<?> fluent, ExecConfig instance) {
        this.fluent = fluent;
        fluent.withAttachStderr(instance.getAttachStderr());
        fluent.withAttachStdin(instance.getAttachStdin());
        fluent.withAttachStdout(instance.getAttachStdout());
        fluent.withCmd(instance.getCmd());
        fluent.withContainer(instance.getContainer());
        fluent.withDetach(instance.getDetach());
        fluent.withPrivileged(instance.getPrivileged());
        fluent.withTty(instance.getTty());
        fluent.withUser(instance.getUser());
    }

    public ExecConfigBuilder(ExecConfig instance) {
        this.fluent = this;
        this.withAttachStderr(instance.getAttachStderr());
        this.withAttachStdin(instance.getAttachStdin());
        this.withAttachStdout(instance.getAttachStdout());
        this.withCmd(instance.getCmd());
        this.withContainer(instance.getContainer());
        this.withDetach(instance.getDetach());
        this.withPrivileged(instance.getPrivileged());
        this.withTty(instance.getTty());
        this.withUser(instance.getUser());
    }

    @Override
    public EditableExecConfig build() {
        EditableExecConfig buildable = new EditableExecConfig(this.fluent.isAttachStderr(), this.fluent.isAttachStdin(), this.fluent.isAttachStdout(), this.fluent.getCmd(), this.fluent.getContainer(), this.fluent.isDetach(), this.fluent.isPrivileged(), this.fluent.isTty(), this.fluent.getUser());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExecConfigBuilder that = (ExecConfigBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

