/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.Container;
import io.fabric8.docker.api.model.ContainerFluent;
import io.fabric8.docker.api.model.ContainerFluentImpl;
import io.fabric8.docker.api.model.EditableContainer;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerBuilder
extends ContainerFluentImpl<ContainerBuilder>
implements VisitableBuilder<Container, ContainerBuilder> {
    ContainerFluent<?> fluent;

    public ContainerBuilder() {
        this(new Container());
    }

    public ContainerBuilder(ContainerFluent<?> fluent) {
        this(fluent, new Container());
    }

    public ContainerBuilder(ContainerFluent<?> fluent, Container instance) {
        this.fluent = fluent;
        fluent.withId(instance.getId());
        fluent.withNames(instance.getNames());
        fluent.withImage(instance.getImage());
        fluent.withImageId(instance.getImageId());
        fluent.withCommand(instance.getCommand());
        fluent.withCreated(instance.getCreated());
        fluent.withPorts(instance.getPorts());
        fluent.withSizeRw(instance.getSizeRw());
        fluent.withSizeRootFs(instance.getSizeRootFs());
        fluent.withLabels(instance.getLabels());
        fluent.withStatus(instance.getStatus());
        fluent.withHostConfig(instance.getHostConfig());
        fluent.withSummaryNetworkSettings(instance.getSummaryNetworkSettings());
    }

    public ContainerBuilder(Container instance) {
        this.fluent = this;
        this.withId(instance.getId());
        this.withNames(instance.getNames());
        this.withImage(instance.getImage());
        this.withImageId(instance.getImageId());
        this.withCommand(instance.getCommand());
        this.withCreated(instance.getCreated());
        this.withPorts(instance.getPorts());
        this.withSizeRw(instance.getSizeRw());
        this.withSizeRootFs(instance.getSizeRootFs());
        this.withLabels(instance.getLabels());
        this.withStatus(instance.getStatus());
        this.withHostConfig(instance.getHostConfig());
        this.withSummaryNetworkSettings(instance.getSummaryNetworkSettings());
    }

    @Override
    public EditableContainer build() {
        EditableContainer buildable = new EditableContainer(this.fluent.getId(), this.fluent.getNames(), this.fluent.getImage(), this.fluent.getImageId(), this.fluent.getCommand(), this.fluent.getCreated(), this.fluent.getPorts(), this.fluent.getSizeRw(), this.fluent.getSizeRootFs(), this.fluent.getLabels(), this.fluent.getStatus(), this.fluent.getHostConfig(), this.fluent.getSummaryNetworkSettings());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerBuilder that = (ContainerBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

