package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class VersionBuilder extends VersionFluentImpl<VersionBuilder> implements VisitableBuilder<Version,VersionBuilder>{

     VersionFluent<?> fluent;
public VersionBuilder(){
    this(new Version());
}
public VersionBuilder( VersionFluent<?> fluent ){
    this(fluent, new Version());
}
public VersionBuilder( VersionFluent<?> fluent , Version instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withArch(instance.getArch()); fluent.withBuildTime(instance.getBuildTime()); fluent.withExperimental(instance.getExperimental()); fluent.withGitCommit(instance.getGitCommit()); fluent.withGoVersion(instance.getGoVersion()); fluent.withKernelVersion(instance.getKernelVersion()); fluent.withOs(instance.getOs()); fluent.withVersion(instance.getVersion()); 
}
public VersionBuilder( Version instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withArch(instance.getArch()); this.withBuildTime(instance.getBuildTime()); this.withExperimental(instance.getExperimental()); this.withGitCommit(instance.getGitCommit()); this.withGoVersion(instance.getGoVersion()); this.withKernelVersion(instance.getKernelVersion()); this.withOs(instance.getOs()); this.withVersion(instance.getVersion()); 
}

public EditableVersion build(){
    EditableVersion buildable = new EditableVersion(fluent.getApiVersion(),fluent.getArch(),fluent.getBuildTime(),fluent.isExperimental(),fluent.getGitCommit(),fluent.getGoVersion(),fluent.getKernelVersion(),fluent.getOs(),fluent.getVersion());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
VersionBuilder that = (VersionBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
