package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import java.util.List;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;

public class SearchResultsFluentImpl<T extends SearchResultsFluent<T>> extends BaseFluent<T> implements SearchResultsFluent<T>{

     Integer numResults;     String query;     List<VisitableBuilder<SearchResult, ?>> results = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public SearchResultsFluentImpl(){
    
}
public SearchResultsFluentImpl( SearchResults instance ){
    this.withNumResults(instance.getNumResults()); this.withQuery(instance.getQuery()); this.withResults(instance.getResults()); 
}

    public Integer getNumResults(){
    return this.numResults;
    }
    public T withNumResults( Integer numResults){
    this.numResults=numResults; return (T) this;
    }
    public String getQuery(){
    return this.query;
    }
    public T withQuery( String query){
    this.query=query; return (T) this;
    }
    public T addToResults( SearchResult ...items){
    for (SearchResult item : items) {SearchResultBuilder builder = new SearchResultBuilder(item);_visitables.add(builder);this.results.add(builder);} return (T)this;
    }
    public T removeFromResults( SearchResult ...items){
    for (SearchResult item : items) {SearchResultBuilder builder = new SearchResultBuilder(item);_visitables.remove(builder);this.results.remove(builder);} return (T)this;
    }
    public List<SearchResult> getResults(){
    return build(results);
    }
    public T withResults( List<SearchResult> results){
    this.results.clear();if (results != null) {for (SearchResult item : results){this.addToResults(item);}} return (T) this;
    }
    public T withResults( SearchResult ...results){
    this.results.clear(); if (results != null) {for (SearchResult item :results){ this.addToResults(item);}} return (T) this;
    }
    public ResultsNested<T> addNewResult(){
    return new ResultsNestedImpl<T>();
    }
    public ResultsNested<T> addNewResultLike( SearchResult item){
    return new ResultsNestedImpl<T>(item);
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SearchResultsFluentImpl that = (SearchResultsFluentImpl) o;
if (numResults != null ? !numResults.equals(that.numResults) :that.numResults != null) return false;
if (query != null ? !query.equals(that.query) :that.query != null) return false;
if (results != null ? !results.equals(that.results) :that.results != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ResultsNestedImpl<N> extends SearchResultFluentImpl<ResultsNested<N>> implements ResultsNested<N>{

        private final SearchResultBuilder builder;
    
             ResultsNestedImpl (){
        this.builder = new SearchResultBuilder(this);
        }
             ResultsNestedImpl ( SearchResult item){
        this.builder = new SearchResultBuilder(this, item);
        }
    
            public N endResult(){
            return and();
        }
            public N and(){
            return (N) SearchResultsFluentImpl.this.addToResults(builder.build());
        }
    
}


}
