package io.fabric8.docker.api.model;

import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class MemoryStatsFluentImpl<T extends MemoryStatsFluent<T>> extends BaseFluent<T> implements MemoryStatsFluent<T>{

     Long failcnt;     Long limit;     Long maxUsage;     Map<String, Long> stats = new HashMap();     Long usage;     Map<String, Object> additionalProperties = new HashMap();
public MemoryStatsFluentImpl(){
    
}
public MemoryStatsFluentImpl( MemoryStats instance ){
    this.withFailcnt(instance.getFailcnt()); this.withLimit(instance.getLimit()); this.withMaxUsage(instance.getMaxUsage()); this.withStats(instance.getStats()); this.withUsage(instance.getUsage()); 
}

    public Long getFailcnt(){
    return this.failcnt;
    }
    public T withFailcnt( Long failcnt){
    this.failcnt=failcnt; return (T) this;
    }
    public Long getLimit(){
    return this.limit;
    }
    public T withLimit( Long limit){
    this.limit=limit; return (T) this;
    }
    public Long getMaxUsage(){
    return this.maxUsage;
    }
    public T withMaxUsage( Long maxUsage){
    this.maxUsage=maxUsage; return (T) this;
    }
    public T addToStats( String key,  Long value){
    if(key != null && value != null) {this.stats.put(key, value);} return (T)this;
    }
    public T addToStats( Map<String, Long> map){
    if(map != null) { this.stats.putAll(map);} return (T)this;
    }
    public T removeFromStats( String key){
    if(key != null) {this.stats.remove(key);} return (T)this;
    }
    public T removeFromStats( Map<String, Long> map){
    if(map != null) { for(Object key : map.keySet()) {this.stats.remove(key);}} return (T)this;
    }
    public Map<String, Long> getStats(){
    return this.stats;
    }
    public T withStats( Map<String, Long> stats){
    this.stats.clear();if (stats != null) {this.stats.putAll(stats);} return (T) this;
    }
    public Long getUsage(){
    return this.usage;
    }
    public T withUsage( Long usage){
    this.usage=usage; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
MemoryStatsFluentImpl that = (MemoryStatsFluentImpl) o;
if (failcnt != null ? !failcnt.equals(that.failcnt) :that.failcnt != null) return false;
if (limit != null ? !limit.equals(that.limit) :that.limit != null) return false;
if (maxUsage != null ? !maxUsage.equals(that.maxUsage) :that.maxUsage != null) return false;
if (stats != null ? !stats.equals(that.stats) :that.stats != null) return false;
if (usage != null ? !usage.equals(that.usage) :that.usage != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
