package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.AbstractCollection;
import java.util.List;
import java.util.Map;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class NetworkSettingsBaseBuilder extends NetworkSettingsBaseFluentImpl<NetworkSettingsBaseBuilder> implements VisitableBuilder<NetworkSettingsBase,NetworkSettingsBaseBuilder>{

     NetworkSettingsBaseFluent<?> fluent;
public NetworkSettingsBaseBuilder(){
    this(new NetworkSettingsBase());
}
public NetworkSettingsBaseBuilder( NetworkSettingsBaseFluent<?> fluent ){
    this(fluent, new NetworkSettingsBase());
}
public NetworkSettingsBaseBuilder( NetworkSettingsBaseFluent<?> fluent , NetworkSettingsBase instance ){
    this.fluent = fluent; fluent.withBridge(instance.getBridge()); fluent.withHairpinMode(instance.getHairpinMode()); fluent.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address()); fluent.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen()); fluent.withPorts(instance.getPorts()); fluent.withSandboxID(instance.getSandboxID()); fluent.withSandboxKey(instance.getSandboxKey()); fluent.withSecondaryIPAddresses(instance.getSecondaryIPAddresses()); fluent.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses()); 
}
public NetworkSettingsBaseBuilder( NetworkSettingsBase instance ){
    this.fluent = this; this.withBridge(instance.getBridge()); this.withHairpinMode(instance.getHairpinMode()); this.withLinkLocalIPv6Address(instance.getLinkLocalIPv6Address()); this.withLinkLocalIPv6PrefixLen(instance.getLinkLocalIPv6PrefixLen()); this.withPorts(instance.getPorts()); this.withSandboxID(instance.getSandboxID()); this.withSandboxKey(instance.getSandboxKey()); this.withSecondaryIPAddresses(instance.getSecondaryIPAddresses()); this.withSecondaryIPv6Addresses(instance.getSecondaryIPv6Addresses()); 
}

public EditableNetworkSettingsBase build(){
    EditableNetworkSettingsBase buildable = new EditableNetworkSettingsBase(fluent.getBridge(),fluent.isHairpinMode(),fluent.getLinkLocalIPv6Address(),fluent.getLinkLocalIPv6PrefixLen(),fluent.getPorts(),fluent.getSandboxID(),fluent.getSandboxKey(),fluent.getSecondaryIPAddresses(),fluent.getSecondaryIPv6Addresses());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
NetworkSettingsBaseBuilder that = (NetworkSettingsBaseBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
