package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.List;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.List;
import java.util.AbstractCollection;
import java.util.Map;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.List;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class HostConfigBuilder extends HostConfigFluentImpl<HostConfigBuilder> implements VisitableBuilder<HostConfig,HostConfigBuilder>{

     HostConfigFluent<?> fluent;
public HostConfigBuilder(){
    this(new HostConfig());
}
public HostConfigBuilder( HostConfigFluent<?> fluent ){
    this(fluent, new HostConfig());
}
public HostConfigBuilder( HostConfigFluent<?> fluent , HostConfig instance ){
    this.fluent = fluent; fluent.withBinds(instance.getBinds()); fluent.withBlkioWeight(instance.getBlkioWeight()); fluent.withCapAdd(instance.getCapAdd()); fluent.withCapDrop(instance.getCapDrop()); fluent.withCgroupParent(instance.getCgroupParent()); fluent.withConsoleSize(instance.getConsoleSize()); fluent.withContainerIDFile(instance.getContainerIDFile()); fluent.withCpuPeriod(instance.getCpuPeriod()); fluent.withCpuQuota(instance.getCpuQuota()); fluent.withCpuShares(instance.getCpuShares()); fluent.withCpusetCpus(instance.getCpusetCpus()); fluent.withCpusetMems(instance.getCpusetMems()); fluent.withDevices(instance.getDevices()); fluent.withDns(instance.getDns()); fluent.withDnsOptions(instance.getDnsOptions()); fluent.withDnsSearch(instance.getDnsSearch()); fluent.withExtraHosts(instance.getExtraHosts()); fluent.withGroupAdd(instance.getGroupAdd()); fluent.withIpcMode(instance.getIpcMode()); fluent.withKernelMemory(instance.getKernelMemory()); fluent.withLinks(instance.getLinks()); fluent.withLogConfig(instance.getLogConfig()); fluent.withLxcConf(instance.getLxcConf()); fluent.withMemory(instance.getMemory()); fluent.withMemoryReservation(instance.getMemoryReservation()); fluent.withMemorySwap(instance.getMemorySwap()); fluent.withMemorySwappiness(instance.getMemorySwappiness()); fluent.withNetworkMode(instance.getNetworkMode()); fluent.withOomKillDisable(instance.getOomKillDisable()); fluent.withPidMode(instance.getPidMode()); fluent.withPortBindings(instance.getPortBindings()); fluent.withPrivileged(instance.getPrivileged()); fluent.withPublishAllPorts(instance.getPublishAllPorts()); fluent.withReadonlyRootfs(instance.getReadonlyRootfs()); fluent.withRestartPolicy(instance.getRestartPolicy()); fluent.withSecurityOpt(instance.getSecurityOpt()); fluent.withUTSMode(instance.getUTSMode()); fluent.withUlimits(instance.getUlimits()); fluent.withVolumeDriver(instance.getVolumeDriver()); fluent.withVolumesFrom(instance.getVolumesFrom()); 
}
public HostConfigBuilder( HostConfig instance ){
    this.fluent = this; this.withBinds(instance.getBinds()); this.withBlkioWeight(instance.getBlkioWeight()); this.withCapAdd(instance.getCapAdd()); this.withCapDrop(instance.getCapDrop()); this.withCgroupParent(instance.getCgroupParent()); this.withConsoleSize(instance.getConsoleSize()); this.withContainerIDFile(instance.getContainerIDFile()); this.withCpuPeriod(instance.getCpuPeriod()); this.withCpuQuota(instance.getCpuQuota()); this.withCpuShares(instance.getCpuShares()); this.withCpusetCpus(instance.getCpusetCpus()); this.withCpusetMems(instance.getCpusetMems()); this.withDevices(instance.getDevices()); this.withDns(instance.getDns()); this.withDnsOptions(instance.getDnsOptions()); this.withDnsSearch(instance.getDnsSearch()); this.withExtraHosts(instance.getExtraHosts()); this.withGroupAdd(instance.getGroupAdd()); this.withIpcMode(instance.getIpcMode()); this.withKernelMemory(instance.getKernelMemory()); this.withLinks(instance.getLinks()); this.withLogConfig(instance.getLogConfig()); this.withLxcConf(instance.getLxcConf()); this.withMemory(instance.getMemory()); this.withMemoryReservation(instance.getMemoryReservation()); this.withMemorySwap(instance.getMemorySwap()); this.withMemorySwappiness(instance.getMemorySwappiness()); this.withNetworkMode(instance.getNetworkMode()); this.withOomKillDisable(instance.getOomKillDisable()); this.withPidMode(instance.getPidMode()); this.withPortBindings(instance.getPortBindings()); this.withPrivileged(instance.getPrivileged()); this.withPublishAllPorts(instance.getPublishAllPorts()); this.withReadonlyRootfs(instance.getReadonlyRootfs()); this.withRestartPolicy(instance.getRestartPolicy()); this.withSecurityOpt(instance.getSecurityOpt()); this.withUTSMode(instance.getUTSMode()); this.withUlimits(instance.getUlimits()); this.withVolumeDriver(instance.getVolumeDriver()); this.withVolumesFrom(instance.getVolumesFrom()); 
}

public EditableHostConfig build(){
    EditableHostConfig buildable = new EditableHostConfig(fluent.getBinds(),fluent.getBlkioWeight(),fluent.getCapAdd(),fluent.getCapDrop(),fluent.getCgroupParent(),fluent.getConsoleSize(),fluent.getContainerIDFile(),fluent.getCpuPeriod(),fluent.getCpuQuota(),fluent.getCpuShares(),fluent.getCpusetCpus(),fluent.getCpusetMems(),fluent.getDevices(),fluent.getDns(),fluent.getDnsOptions(),fluent.getDnsSearch(),fluent.getExtraHosts(),fluent.getGroupAdd(),fluent.getIpcMode(),fluent.getKernelMemory(),fluent.getLinks(),fluent.getLogConfig(),fluent.getLxcConf(),fluent.getMemory(),fluent.getMemoryReservation(),fluent.getMemorySwap(),fluent.getMemorySwappiness(),fluent.getNetworkMode(),fluent.isOomKillDisable(),fluent.getPidMode(),fluent.getPortBindings(),fluent.isPrivileged(),fluent.isPublishAllPorts(),fluent.isReadonlyRootfs(),fluent.getRestartPolicy(),fluent.getSecurityOpt(),fluent.getUTSMode(),fluent.getUlimits(),fluent.getVolumeDriver(),fluent.getVolumesFrom());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
HostConfigBuilder that = (HostConfigBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
