package io.fabric8.docker.api.model;

import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class ContainerStateFluentImpl<T extends ContainerStateFluent<T>> extends BaseFluent<T> implements ContainerStateFluent<T>{

     Boolean Dead;     String Error;     Integer ExitCode;     String FinishedAt;     Boolean OOMKilled;     Boolean Paused;     Integer Pid;     Boolean Restarting;     Boolean Running;     String StartedAt;     String Status;     Map<String, Object> additionalProperties = new HashMap();
public ContainerStateFluentImpl(){
    
}
public ContainerStateFluentImpl( ContainerState instance ){
    this.withDead(instance.getDead()); this.withError(instance.getError()); this.withExitCode(instance.getExitCode()); this.withFinishedAt(instance.getFinishedAt()); this.withOOMKilled(instance.getOOMKilled()); this.withPaused(instance.getPaused()); this.withPid(instance.getPid()); this.withRestarting(instance.getRestarting()); this.withRunning(instance.getRunning()); this.withStartedAt(instance.getStartedAt()); this.withStatus(instance.getStatus()); 
}

    public Boolean isDead(){
    return this.Dead;
    }
    public T withDead( Boolean Dead){
    this.Dead=Dead; return (T) this;
    }
    public String getError(){
    return this.Error;
    }
    public T withError( String Error){
    this.Error=Error; return (T) this;
    }
    public Integer getExitCode(){
    return this.ExitCode;
    }
    public T withExitCode( Integer ExitCode){
    this.ExitCode=ExitCode; return (T) this;
    }
    public String getFinishedAt(){
    return this.FinishedAt;
    }
    public T withFinishedAt( String FinishedAt){
    this.FinishedAt=FinishedAt; return (T) this;
    }
    public Boolean isOOMKilled(){
    return this.OOMKilled;
    }
    public T withOOMKilled( Boolean OOMKilled){
    this.OOMKilled=OOMKilled; return (T) this;
    }
    public Boolean isPaused(){
    return this.Paused;
    }
    public T withPaused( Boolean Paused){
    this.Paused=Paused; return (T) this;
    }
    public Integer getPid(){
    return this.Pid;
    }
    public T withPid( Integer Pid){
    this.Pid=Pid; return (T) this;
    }
    public Boolean isRestarting(){
    return this.Restarting;
    }
    public T withRestarting( Boolean Restarting){
    this.Restarting=Restarting; return (T) this;
    }
    public Boolean isRunning(){
    return this.Running;
    }
    public T withRunning( Boolean Running){
    this.Running=Running; return (T) this;
    }
    public String getStartedAt(){
    return this.StartedAt;
    }
    public T withStartedAt( String StartedAt){
    this.StartedAt=StartedAt; return (T) this;
    }
    public String getStatus(){
    return this.Status;
    }
    public T withStatus( String Status){
    this.Status=Status; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerStateFluentImpl that = (ContainerStateFluentImpl) o;
if (Dead != null ? !Dead.equals(that.Dead) :that.Dead != null) return false;
if (Error != null ? !Error.equals(that.Error) :that.Error != null) return false;
if (ExitCode != null ? !ExitCode.equals(that.ExitCode) :that.ExitCode != null) return false;
if (FinishedAt != null ? !FinishedAt.equals(that.FinishedAt) :that.FinishedAt != null) return false;
if (OOMKilled != null ? !OOMKilled.equals(that.OOMKilled) :that.OOMKilled != null) return false;
if (Paused != null ? !Paused.equals(that.Paused) :that.Paused != null) return false;
if (Pid != null ? !Pid.equals(that.Pid) :that.Pid != null) return false;
if (Restarting != null ? !Restarting.equals(that.Restarting) :that.Restarting != null) return false;
if (Running != null ? !Running.equals(that.Running) :that.Running != null) return false;
if (StartedAt != null ? !StartedAt.equals(that.StartedAt) :that.StartedAt != null) return false;
if (Status != null ? !Status.equals(that.Status) :that.Status != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
