package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.BaseFluent;

public class ContainerJSONBaseFluentImpl<T extends ContainerJSONBaseFluent<T>> extends BaseFluent<T> implements ContainerJSONBaseFluent<T>{

     String AppArmorProfile;     List<String> Args = new ArrayList();     String Created;     String Driver;     String ExecDriver;     List<String> ExecIDs = new ArrayList();     VisitableBuilder<GraphDriverData, ?> GraphDriver;     VisitableBuilder<HostConfig, ?> HostConfig;     String HostnamePath;     String HostsPath;     String Id;     String Image;     String LogPath;     String MountLabel;     String Name;     String Path;     String ProcessLabel;     String ResolvConfPath;     Integer RestartCount;     Long SizeRootFs;     Long SizeRw;     VisitableBuilder<ContainerState, ?> State;     Map<String, Object> additionalProperties = new HashMap();
public ContainerJSONBaseFluentImpl(){
    
}
public ContainerJSONBaseFluentImpl( ContainerJSONBase instance ){
    this.withAppArmorProfile(instance.getAppArmorProfile()); this.withArgs(instance.getArgs()); this.withCreated(instance.getCreated()); this.withDriver(instance.getDriver()); this.withExecDriver(instance.getExecDriver()); this.withExecIDs(instance.getExecIDs()); this.withGraphDriver(instance.getGraphDriver()); this.withHostConfig(instance.getHostConfig()); this.withHostnamePath(instance.getHostnamePath()); this.withHostsPath(instance.getHostsPath()); this.withId(instance.getId()); this.withImage(instance.getImage()); this.withLogPath(instance.getLogPath()); this.withMountLabel(instance.getMountLabel()); this.withName(instance.getName()); this.withPath(instance.getPath()); this.withProcessLabel(instance.getProcessLabel()); this.withResolvConfPath(instance.getResolvConfPath()); this.withRestartCount(instance.getRestartCount()); this.withSizeRootFs(instance.getSizeRootFs()); this.withSizeRw(instance.getSizeRw()); this.withState(instance.getState()); 
}

    public String getAppArmorProfile(){
    return this.AppArmorProfile;
    }
    public T withAppArmorProfile( String AppArmorProfile){
    this.AppArmorProfile=AppArmorProfile; return (T) this;
    }
    public T addToArgs( String ...items){
    for (String item : items) {this.Args.add(item);} return (T)this;
    }
    public T removeFromArgs( String ...items){
    for (String item : items) {this.Args.remove(item);} return (T)this;
    }
    public List<String> getArgs(){
    return this.Args;
    }
    public T withArgs( List<String> Args){
    this.Args.clear();if (Args != null) {for (String item : Args){this.addToArgs(item);}} return (T) this;
    }
    public T withArgs( String ...Args){
    this.Args.clear(); if (Args != null) {for (String item :Args){ this.addToArgs(item);}} return (T) this;
    }
    public String getCreated(){
    return this.Created;
    }
    public T withCreated( String Created){
    this.Created=Created; return (T) this;
    }
    public String getDriver(){
    return this.Driver;
    }
    public T withDriver( String Driver){
    this.Driver=Driver; return (T) this;
    }
    public String getExecDriver(){
    return this.ExecDriver;
    }
    public T withExecDriver( String ExecDriver){
    this.ExecDriver=ExecDriver; return (T) this;
    }
    public T addToExecIDs( String ...items){
    for (String item : items) {this.ExecIDs.add(item);} return (T)this;
    }
    public T removeFromExecIDs( String ...items){
    for (String item : items) {this.ExecIDs.remove(item);} return (T)this;
    }
    public List<String> getExecIDs(){
    return this.ExecIDs;
    }
    public T withExecIDs( List<String> ExecIDs){
    this.ExecIDs.clear();if (ExecIDs != null) {for (String item : ExecIDs){this.addToExecIDs(item);}} return (T) this;
    }
    public T withExecIDs( String ...ExecIDs){
    this.ExecIDs.clear(); if (ExecIDs != null) {for (String item :ExecIDs){ this.addToExecIDs(item);}} return (T) this;
    }
    public GraphDriverData getGraphDriver(){
    return this.GraphDriver!=null?this.GraphDriver.build():null;
    }
    public T withGraphDriver( GraphDriverData GraphDriver){
    if (GraphDriver!=null){ this.GraphDriver= new GraphDriverDataBuilder(GraphDriver); _visitables.add(this.GraphDriver);} return (T) this;
    }
    public GraphDriverNested<T> withNewGraphDriver(){
    return new GraphDriverNestedImpl<T>();
    }
    public GraphDriverNested<T> withNewGraphDriverLike( GraphDriverData item){
    return new GraphDriverNestedImpl<T>(item);
    }
    public GraphDriverNested<T> editGraphDriver(){
    return withNewGraphDriverLike(getGraphDriver());
    }
    public HostConfig getHostConfig(){
    return this.HostConfig!=null?this.HostConfig.build():null;
    }
    public T withHostConfig( HostConfig HostConfig){
    if (HostConfig!=null){ this.HostConfig= new HostConfigBuilder(HostConfig); _visitables.add(this.HostConfig);} return (T) this;
    }
    public HostConfigNested<T> withNewHostConfig(){
    return new HostConfigNestedImpl<T>();
    }
    public HostConfigNested<T> withNewHostConfigLike( HostConfig item){
    return new HostConfigNestedImpl<T>(item);
    }
    public HostConfigNested<T> editHostConfig(){
    return withNewHostConfigLike(getHostConfig());
    }
    public String getHostnamePath(){
    return this.HostnamePath;
    }
    public T withHostnamePath( String HostnamePath){
    this.HostnamePath=HostnamePath; return (T) this;
    }
    public String getHostsPath(){
    return this.HostsPath;
    }
    public T withHostsPath( String HostsPath){
    this.HostsPath=HostsPath; return (T) this;
    }
    public String getId(){
    return this.Id;
    }
    public T withId( String Id){
    this.Id=Id; return (T) this;
    }
    public String getImage(){
    return this.Image;
    }
    public T withImage( String Image){
    this.Image=Image; return (T) this;
    }
    public String getLogPath(){
    return this.LogPath;
    }
    public T withLogPath( String LogPath){
    this.LogPath=LogPath; return (T) this;
    }
    public String getMountLabel(){
    return this.MountLabel;
    }
    public T withMountLabel( String MountLabel){
    this.MountLabel=MountLabel; return (T) this;
    }
    public String getName(){
    return this.Name;
    }
    public T withName( String Name){
    this.Name=Name; return (T) this;
    }
    public String getPath(){
    return this.Path;
    }
    public T withPath( String Path){
    this.Path=Path; return (T) this;
    }
    public String getProcessLabel(){
    return this.ProcessLabel;
    }
    public T withProcessLabel( String ProcessLabel){
    this.ProcessLabel=ProcessLabel; return (T) this;
    }
    public String getResolvConfPath(){
    return this.ResolvConfPath;
    }
    public T withResolvConfPath( String ResolvConfPath){
    this.ResolvConfPath=ResolvConfPath; return (T) this;
    }
    public Integer getRestartCount(){
    return this.RestartCount;
    }
    public T withRestartCount( Integer RestartCount){
    this.RestartCount=RestartCount; return (T) this;
    }
    public Long getSizeRootFs(){
    return this.SizeRootFs;
    }
    public T withSizeRootFs( Long SizeRootFs){
    this.SizeRootFs=SizeRootFs; return (T) this;
    }
    public Long getSizeRw(){
    return this.SizeRw;
    }
    public T withSizeRw( Long SizeRw){
    this.SizeRw=SizeRw; return (T) this;
    }
    public ContainerState getState(){
    return this.State!=null?this.State.build():null;
    }
    public T withState( ContainerState State){
    if (State!=null){ this.State= new ContainerStateBuilder(State); _visitables.add(this.State);} return (T) this;
    }
    public StateNested<T> withNewState(){
    return new StateNestedImpl<T>();
    }
    public StateNested<T> withNewStateLike( ContainerState item){
    return new StateNestedImpl<T>(item);
    }
    public StateNested<T> editState(){
    return withNewStateLike(getState());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerJSONBaseFluentImpl that = (ContainerJSONBaseFluentImpl) o;
if (AppArmorProfile != null ? !AppArmorProfile.equals(that.AppArmorProfile) :that.AppArmorProfile != null) return false;
if (Args != null ? !Args.equals(that.Args) :that.Args != null) return false;
if (Created != null ? !Created.equals(that.Created) :that.Created != null) return false;
if (Driver != null ? !Driver.equals(that.Driver) :that.Driver != null) return false;
if (ExecDriver != null ? !ExecDriver.equals(that.ExecDriver) :that.ExecDriver != null) return false;
if (ExecIDs != null ? !ExecIDs.equals(that.ExecIDs) :that.ExecIDs != null) return false;
if (GraphDriver != null ? !GraphDriver.equals(that.GraphDriver) :that.GraphDriver != null) return false;
if (HostConfig != null ? !HostConfig.equals(that.HostConfig) :that.HostConfig != null) return false;
if (HostnamePath != null ? !HostnamePath.equals(that.HostnamePath) :that.HostnamePath != null) return false;
if (HostsPath != null ? !HostsPath.equals(that.HostsPath) :that.HostsPath != null) return false;
if (Id != null ? !Id.equals(that.Id) :that.Id != null) return false;
if (Image != null ? !Image.equals(that.Image) :that.Image != null) return false;
if (LogPath != null ? !LogPath.equals(that.LogPath) :that.LogPath != null) return false;
if (MountLabel != null ? !MountLabel.equals(that.MountLabel) :that.MountLabel != null) return false;
if (Name != null ? !Name.equals(that.Name) :that.Name != null) return false;
if (Path != null ? !Path.equals(that.Path) :that.Path != null) return false;
if (ProcessLabel != null ? !ProcessLabel.equals(that.ProcessLabel) :that.ProcessLabel != null) return false;
if (ResolvConfPath != null ? !ResolvConfPath.equals(that.ResolvConfPath) :that.ResolvConfPath != null) return false;
if (RestartCount != null ? !RestartCount.equals(that.RestartCount) :that.RestartCount != null) return false;
if (SizeRootFs != null ? !SizeRootFs.equals(that.SizeRootFs) :that.SizeRootFs != null) return false;
if (SizeRw != null ? !SizeRw.equals(that.SizeRw) :that.SizeRw != null) return false;
if (State != null ? !State.equals(that.State) :that.State != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class GraphDriverNestedImpl<N> extends GraphDriverDataFluentImpl<GraphDriverNested<N>> implements GraphDriverNested<N>{

        private final GraphDriverDataBuilder builder;
    
             GraphDriverNestedImpl (){
        this.builder = new GraphDriverDataBuilder(this);
        }
             GraphDriverNestedImpl ( GraphDriverData item){
        this.builder = new GraphDriverDataBuilder(this, item);
        }
    
            public N endGraphDriver(){
            return and();
        }
            public N and(){
            return (N) ContainerJSONBaseFluentImpl.this.withGraphDriver(builder.build());
        }
    
}
    public class HostConfigNestedImpl<N> extends HostConfigFluentImpl<HostConfigNested<N>> implements HostConfigNested<N>{

        private final HostConfigBuilder builder;
    
             HostConfigNestedImpl (){
        this.builder = new HostConfigBuilder(this);
        }
             HostConfigNestedImpl ( HostConfig item){
        this.builder = new HostConfigBuilder(this, item);
        }
    
            public N and(){
            return (N) ContainerJSONBaseFluentImpl.this.withHostConfig(builder.build());
        }
            public N endHostConfig(){
            return and();
        }
    
}
    public class StateNestedImpl<N> extends ContainerStateFluentImpl<StateNested<N>> implements StateNested<N>{

        private final ContainerStateBuilder builder;
    
             StateNestedImpl (){
        this.builder = new ContainerStateBuilder(this);
        }
             StateNestedImpl ( ContainerState item){
        this.builder = new ContainerStateBuilder(this, item);
        }
    
            public N and(){
            return (N) ContainerJSONBaseFluentImpl.this.withState(builder.build());
        }
            public N endState(){
            return and();
        }
    
}


}
