package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class ContainerBuilder extends ContainerFluentImpl<ContainerBuilder> implements VisitableBuilder<Container,ContainerBuilder>{

     ContainerFluent<?> fluent;
public ContainerBuilder(){
    this(new Container());
}
public ContainerBuilder( ContainerFluent<?> fluent ){
    this(fluent, new Container());
}
public ContainerBuilder( ContainerFluent<?> fluent , Container instance ){
    this.fluent = fluent; fluent.withId(instance.getId()); fluent.withNames(instance.getNames()); fluent.withImage(instance.getImage()); fluent.withImageId(instance.getImageId()); fluent.withCommand(instance.getCommand()); fluent.withCreated(instance.getCreated()); fluent.withPorts(instance.getPorts()); fluent.withSizeRw(instance.getSizeRw()); fluent.withSizeRootFs(instance.getSizeRootFs()); fluent.withLabels(instance.getLabels()); fluent.withStatus(instance.getStatus()); fluent.withHostConfig(instance.getHostConfig()); fluent.withSummaryNetworkSettings(instance.getSummaryNetworkSettings()); 
}
public ContainerBuilder( Container instance ){
    this.fluent = this; this.withId(instance.getId()); this.withNames(instance.getNames()); this.withImage(instance.getImage()); this.withImageId(instance.getImageId()); this.withCommand(instance.getCommand()); this.withCreated(instance.getCreated()); this.withPorts(instance.getPorts()); this.withSizeRw(instance.getSizeRw()); this.withSizeRootFs(instance.getSizeRootFs()); this.withLabels(instance.getLabels()); this.withStatus(instance.getStatus()); this.withHostConfig(instance.getHostConfig()); this.withSummaryNetworkSettings(instance.getSummaryNetworkSettings()); 
}

public EditableContainer build(){
    EditableContainer buildable = new EditableContainer(fluent.getId(),fluent.getNames(),fluent.getImage(),fluent.getImageId(),fluent.getCommand(),fluent.getCreated(),fluent.getPorts(),fluent.getSizeRw(),fluent.getSizeRootFs(),fluent.getLabels(),fluent.getStatus(),fluent.getHostConfig(),fluent.getSummaryNetworkSettings());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ContainerBuilder that = (ContainerBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
