/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableLogConfig;
import io.fabric8.docker.api.model.LogConfig;
import io.fabric8.docker.api.model.LogConfigFluent;
import io.fabric8.docker.api.model.LogConfigFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class LogConfigBuilder
extends LogConfigFluentImpl<LogConfigBuilder>
implements VisitableBuilder<LogConfig, LogConfigBuilder> {
    LogConfigFluent<?> fluent;

    public LogConfigBuilder() {
        this(new LogConfig());
    }

    public LogConfigBuilder(LogConfigFluent<?> fluent) {
        this(fluent, new LogConfig());
    }

    public LogConfigBuilder(LogConfigFluent<?> fluent, LogConfig instance) {
        this.fluent = fluent;
        fluent.withConfig(instance.getConfig());
        fluent.withType(instance.getType());
    }

    public LogConfigBuilder(LogConfig instance) {
        this.fluent = this;
        this.withConfig(instance.getConfig());
        this.withType(instance.getType());
    }

    @Override
    public EditableLogConfig build() {
        EditableLogConfig buildable = new EditableLogConfig(this.fluent.getConfig(), this.fluent.getType());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LogConfigBuilder that = (LogConfigBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

