/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.ContainerCreateRequest;
import io.fabric8.docker.api.model.ContainerCreateRequestFluent;
import io.fabric8.docker.api.model.HostConfig;
import io.fabric8.docker.api.model.HostConfigBuilder;
import io.fabric8.docker.api.model.HostConfigFluentImpl;
import io.fabric8.docker.api.model.Protocol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContainerCreateRequestFluentImpl<T extends ContainerCreateRequestFluent<T>>
extends BaseFluent<T>
implements ContainerCreateRequestFluent<T> {
    String name;
    String hostname;
    String domainname;
    String user;
    String memory;
    String memorySwap;
    String memoryReservation;
    String kernelMemory;
    String cpuShares;
    String cpuPeriod;
    String cpuQuota;
    String cpuset;
    String cpusetCpus;
    String cpusetMems;
    Integer blkioWeight;
    Integer memorySwappiness;
    Boolean oomKillDisable;
    Boolean attachStdin;
    Boolean attachStdout;
    Boolean attachStderr;
    Boolean tty;
    Boolean openStdin;
    Boolean stdinOnce;
    Map<String, String> env = new HashMap<String, String>();
    List<String> cmd = new ArrayList<String>();
    String entrypoint;
    String image;
    Map<String, String> labels = new HashMap<String, String>();
    Map<String, String> mounts = new HashMap<String, String>();
    String workingDir;
    Boolean networkDisabled;
    String macAddress;
    Map<Integer, Protocol> exposedPorts = new HashMap<Integer, Protocol>();
    String stopSignal;
    VisitableBuilder<HostConfig, ?> hostConfig;

    public ContainerCreateRequestFluentImpl() {
    }

    public ContainerCreateRequestFluentImpl(ContainerCreateRequest instance) {
        this.withName(instance.getName());
        this.withCpuset(instance.getCpuset());
        this.withHostname(instance.getHostname());
        this.withDomainname(instance.getDomainname());
        this.withUser(instance.getUser());
        this.withMemory(instance.getMemory());
        this.withMemorySwap(instance.getMemorySwap());
        this.withMemoryReservation(instance.getMemoryReservation());
        this.withKernelMemory(instance.getKernelMemory());
        this.withCpuShares(instance.getCpuShares());
        this.withCpuPeriod(instance.getCpuPeriod());
        this.withCpuQuota(instance.getCpuQuota());
        this.withCpusetCpus(instance.getCpusetCpus());
        this.withCpusetMems(instance.getCpusetMems());
        this.withBlkioWeight(instance.getBlkioWeight());
        this.withMemorySwappiness(instance.getMemorySwappiness());
        this.withOomKillDisable(instance.getOomKillDisable());
        this.withAttachStdin(instance.getAttachStdin());
        this.withAttachStdout(instance.getAttachStdout());
        this.withAttachStderr(instance.getAttachStderr());
        this.withTty(instance.getTty());
        this.withOpenStdin(instance.getOpenStdin());
        this.withStdinOnce(instance.getStdinOnce());
        this.withEnv(instance.getEnv());
        this.withCmd(instance.getCmd());
        this.withEntrypoint(instance.getEntrypoint());
        this.withImage(instance.getImage());
        this.withLabels(instance.getLabels());
        this.withMounts(instance.getMounts());
        this.withWorkingDir(instance.getWorkingDir());
        this.withNetworkDisabled(instance.getNetworkDisabled());
        this.withMacAddress(instance.getMacAddress());
        this.withExposedPorts(instance.getExposedPorts());
        this.withStopSignal(instance.getStopSignal());
        this.withHostConfig(instance.getHostConfig());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T withName(String name) {
        this.name = name;
        return (T)this;
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public T withHostname(String hostname) {
        this.hostname = hostname;
        return (T)this;
    }

    @Override
    public String getDomainname() {
        return this.domainname;
    }

    @Override
    public T withDomainname(String domainname) {
        this.domainname = domainname;
        return (T)this;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public T withUser(String user) {
        this.user = user;
        return (T)this;
    }

    @Override
    public String getMemory() {
        return this.memory;
    }

    @Override
    public T withMemory(String memory) {
        this.memory = memory;
        return (T)this;
    }

    @Override
    public String getMemorySwap() {
        return this.memorySwap;
    }

    @Override
    public T withMemorySwap(String memorySwap) {
        this.memorySwap = memorySwap;
        return (T)this;
    }

    @Override
    public String getMemoryReservation() {
        return this.memoryReservation;
    }

    @Override
    public T withMemoryReservation(String memoryReservation) {
        this.memoryReservation = memoryReservation;
        return (T)this;
    }

    @Override
    public String getKernelMemory() {
        return this.kernelMemory;
    }

    @Override
    public T withKernelMemory(String kernelMemory) {
        this.kernelMemory = kernelMemory;
        return (T)this;
    }

    @Override
    public String getCpuShares() {
        return this.cpuShares;
    }

    @Override
    public T withCpuShares(String cpuShares) {
        this.cpuShares = cpuShares;
        return (T)this;
    }

    @Override
    public String getCpuPeriod() {
        return this.cpuPeriod;
    }

    @Override
    public T withCpuPeriod(String cpuPeriod) {
        this.cpuPeriod = cpuPeriod;
        return (T)this;
    }

    @Override
    public String getCpuQuota() {
        return this.cpuQuota;
    }

    @Override
    public T withCpuQuota(String cpuQuota) {
        this.cpuQuota = cpuQuota;
        return (T)this;
    }

    @Override
    public String getCpuset() {
        return this.cpuset;
    }

    @Override
    public T withCpuset(String cpuset) {
        this.cpuset = cpuset;
        return (T)this;
    }

    @Override
    public String getCpusetCpus() {
        return this.cpusetCpus;
    }

    @Override
    public T withCpusetCpus(String cpusetCpus) {
        this.cpusetCpus = cpusetCpus;
        return (T)this;
    }

    @Override
    public String getCpusetMems() {
        return this.cpusetMems;
    }

    @Override
    public T withCpusetMems(String cpusetMems) {
        this.cpusetMems = cpusetMems;
        return (T)this;
    }

    @Override
    public Integer getBlkioWeight() {
        return this.blkioWeight;
    }

    @Override
    public T withBlkioWeight(Integer blkioWeight) {
        this.blkioWeight = blkioWeight;
        return (T)this;
    }

    @Override
    public Integer getMemorySwappiness() {
        return this.memorySwappiness;
    }

    @Override
    public T withMemorySwappiness(Integer memorySwappiness) {
        this.memorySwappiness = memorySwappiness;
        return (T)this;
    }

    @Override
    public Boolean isOomKillDisable() {
        return this.oomKillDisable;
    }

    @Override
    public T withOomKillDisable(Boolean oomKillDisable) {
        this.oomKillDisable = oomKillDisable;
        return (T)this;
    }

    @Override
    public Boolean isAttachStdin() {
        return this.attachStdin;
    }

    @Override
    public T withAttachStdin(Boolean attachStdin) {
        this.attachStdin = attachStdin;
        return (T)this;
    }

    @Override
    public Boolean isAttachStdout() {
        return this.attachStdout;
    }

    @Override
    public T withAttachStdout(Boolean attachStdout) {
        this.attachStdout = attachStdout;
        return (T)this;
    }

    @Override
    public Boolean isAttachStderr() {
        return this.attachStderr;
    }

    @Override
    public T withAttachStderr(Boolean attachStderr) {
        this.attachStderr = attachStderr;
        return (T)this;
    }

    @Override
    public Boolean isTty() {
        return this.tty;
    }

    @Override
    public T withTty(Boolean tty) {
        this.tty = tty;
        return (T)this;
    }

    @Override
    public Boolean isOpenStdin() {
        return this.openStdin;
    }

    @Override
    public T withOpenStdin(Boolean openStdin) {
        this.openStdin = openStdin;
        return (T)this;
    }

    @Override
    public Boolean isStdinOnce() {
        return this.stdinOnce;
    }

    @Override
    public T withStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return (T)this;
    }

    @Override
    public T addToEnv(String key, String value) {
        if (key != null && value != null) {
            this.env.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToEnv(Map<String, String> map) {
        if (map != null) {
            this.env.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromEnv(String key) {
        if (key != null) {
            this.env.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromEnv(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.env.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, String> getEnv() {
        return this.env;
    }

    @Override
    public T withEnv(Map<String, String> env) {
        this.env.clear();
        if (env != null) {
            this.env.putAll(env);
        }
        return (T)this;
    }

    @Override
    public T addToCmd(String ... items) {
        for (String item : items) {
            this.cmd.add(item);
        }
        return (T)this;
    }

    @Override
    public T removeFromCmd(String ... items) {
        for (String item : items) {
            this.cmd.remove(item);
        }
        return (T)this;
    }

    @Override
    public List<String> getCmd() {
        return this.cmd;
    }

    @Override
    public T withCmd(List<String> cmd) {
        this.cmd.clear();
        if (cmd != null) {
            for (String item : cmd) {
                this.addToCmd(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withCmd(String ... cmd) {
        this.cmd.clear();
        if (cmd != null) {
            for (String item : cmd) {
                this.addToCmd(item);
            }
        }
        return (T)this;
    }

    @Override
    public String getEntrypoint() {
        return this.entrypoint;
    }

    @Override
    public T withEntrypoint(String entrypoint) {
        this.entrypoint = entrypoint;
        return (T)this;
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public T withImage(String image) {
        this.image = image;
        return (T)this;
    }

    @Override
    public T addToLabels(String key, String value) {
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToLabels(Map<String, String> map) {
        if (map != null) {
            this.labels.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromLabels(String key) {
        if (key != null) {
            this.labels.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromLabels(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.labels.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public T withLabels(Map<String, String> labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.putAll(labels);
        }
        return (T)this;
    }

    @Override
    public T addToMounts(String key, String value) {
        if (key != null && value != null) {
            this.mounts.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToMounts(Map<String, String> map) {
        if (map != null) {
            this.mounts.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromMounts(String key) {
        if (key != null) {
            this.mounts.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromMounts(Map<String, String> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.mounts.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, String> getMounts() {
        return this.mounts;
    }

    @Override
    public T withMounts(Map<String, String> mounts) {
        this.mounts.clear();
        if (mounts != null) {
            this.mounts.putAll(mounts);
        }
        return (T)this;
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public T withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (T)this;
    }

    @Override
    public Boolean isNetworkDisabled() {
        return this.networkDisabled;
    }

    @Override
    public T withNetworkDisabled(Boolean networkDisabled) {
        this.networkDisabled = networkDisabled;
        return (T)this;
    }

    @Override
    public String getMacAddress() {
        return this.macAddress;
    }

    @Override
    public T withMacAddress(String macAddress) {
        this.macAddress = macAddress;
        return (T)this;
    }

    @Override
    public T addToExposedPorts(Integer key, Protocol value) {
        if (key != null && value != null) {
            this.exposedPorts.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToExposedPorts(Map<Integer, Protocol> map) {
        if (map != null) {
            this.exposedPorts.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromExposedPorts(Integer key) {
        if (key != null) {
            this.exposedPorts.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromExposedPorts(Map<Integer, Protocol> map) {
        if (map != null) {
            for (Integer key : map.keySet()) {
                this.exposedPorts.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<Integer, Protocol> getExposedPorts() {
        return this.exposedPorts;
    }

    @Override
    public T withExposedPorts(Map<Integer, Protocol> exposedPorts) {
        this.exposedPorts.clear();
        if (exposedPorts != null) {
            this.exposedPorts.putAll(exposedPorts);
        }
        return (T)this;
    }

    @Override
    public String getStopSignal() {
        return this.stopSignal;
    }

    @Override
    public T withStopSignal(String stopSignal) {
        this.stopSignal = stopSignal;
        return (T)this;
    }

    @Override
    public HostConfig getHostConfig() {
        return this.hostConfig != null ? (HostConfig)this.hostConfig.build() : null;
    }

    @Override
    public T withHostConfig(HostConfig hostConfig) {
        if (hostConfig != null) {
            this.hostConfig = new HostConfigBuilder(hostConfig);
            this._visitables.add(this.hostConfig);
        }
        return (T)this;
    }

    @Override
    public ContainerCreateRequestFluent.HostConfigNested<T> withNewHostConfig() {
        return new HostConfigNestedImpl();
    }

    @Override
    public ContainerCreateRequestFluent.HostConfigNested<T> withNewHostConfigLike(HostConfig item) {
        return new HostConfigNestedImpl(item);
    }

    @Override
    public ContainerCreateRequestFluent.HostConfigNested<T> editHostConfig() {
        return this.withNewHostConfigLike(this.getHostConfig());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerCreateRequestFluentImpl that = (ContainerCreateRequestFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.domainname != null ? !this.domainname.equals(that.domainname) : that.domainname != null) {
            return false;
        }
        if (this.user != null ? !this.user.equals(that.user) : that.user != null) {
            return false;
        }
        if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) {
            return false;
        }
        if (this.memorySwap != null ? !this.memorySwap.equals(that.memorySwap) : that.memorySwap != null) {
            return false;
        }
        if (this.memoryReservation != null ? !this.memoryReservation.equals(that.memoryReservation) : that.memoryReservation != null) {
            return false;
        }
        if (this.kernelMemory != null ? !this.kernelMemory.equals(that.kernelMemory) : that.kernelMemory != null) {
            return false;
        }
        if (this.cpuShares != null ? !this.cpuShares.equals(that.cpuShares) : that.cpuShares != null) {
            return false;
        }
        if (this.cpuPeriod != null ? !this.cpuPeriod.equals(that.cpuPeriod) : that.cpuPeriod != null) {
            return false;
        }
        if (this.cpuQuota != null ? !this.cpuQuota.equals(that.cpuQuota) : that.cpuQuota != null) {
            return false;
        }
        if (this.cpuset != null ? !this.cpuset.equals(that.cpuset) : that.cpuset != null) {
            return false;
        }
        if (this.cpusetCpus != null ? !this.cpusetCpus.equals(that.cpusetCpus) : that.cpusetCpus != null) {
            return false;
        }
        if (this.cpusetMems != null ? !this.cpusetMems.equals(that.cpusetMems) : that.cpusetMems != null) {
            return false;
        }
        if (this.blkioWeight != null ? !this.blkioWeight.equals(that.blkioWeight) : that.blkioWeight != null) {
            return false;
        }
        if (this.memorySwappiness != null ? !this.memorySwappiness.equals(that.memorySwappiness) : that.memorySwappiness != null) {
            return false;
        }
        if (this.oomKillDisable != null ? !this.oomKillDisable.equals(that.oomKillDisable) : that.oomKillDisable != null) {
            return false;
        }
        if (this.attachStdin != null ? !this.attachStdin.equals(that.attachStdin) : that.attachStdin != null) {
            return false;
        }
        if (this.attachStdout != null ? !this.attachStdout.equals(that.attachStdout) : that.attachStdout != null) {
            return false;
        }
        if (this.attachStderr != null ? !this.attachStderr.equals(that.attachStderr) : that.attachStderr != null) {
            return false;
        }
        if (this.tty != null ? !this.tty.equals(that.tty) : that.tty != null) {
            return false;
        }
        if (this.openStdin != null ? !this.openStdin.equals(that.openStdin) : that.openStdin != null) {
            return false;
        }
        if (this.stdinOnce != null ? !this.stdinOnce.equals(that.stdinOnce) : that.stdinOnce != null) {
            return false;
        }
        if (this.env != null ? !this.env.equals(that.env) : that.env != null) {
            return false;
        }
        if (this.cmd != null ? !this.cmd.equals(that.cmd) : that.cmd != null) {
            return false;
        }
        if (this.entrypoint != null ? !this.entrypoint.equals(that.entrypoint) : that.entrypoint != null) {
            return false;
        }
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.labels != null ? !this.labels.equals(that.labels) : that.labels != null) {
            return false;
        }
        if (this.mounts != null ? !this.mounts.equals(that.mounts) : that.mounts != null) {
            return false;
        }
        if (this.workingDir != null ? !this.workingDir.equals(that.workingDir) : that.workingDir != null) {
            return false;
        }
        if (this.networkDisabled != null ? !this.networkDisabled.equals(that.networkDisabled) : that.networkDisabled != null) {
            return false;
        }
        if (this.macAddress != null ? !this.macAddress.equals(that.macAddress) : that.macAddress != null) {
            return false;
        }
        if (this.exposedPorts != null ? !this.exposedPorts.equals(that.exposedPorts) : that.exposedPorts != null) {
            return false;
        }
        if (this.stopSignal != null ? !this.stopSignal.equals(that.stopSignal) : that.stopSignal != null) {
            return false;
        }
        return !(this.hostConfig != null ? !this.hostConfig.equals(that.hostConfig) : that.hostConfig != null);
    }

    public class HostConfigNestedImpl<N>
    extends HostConfigFluentImpl<ContainerCreateRequestFluent.HostConfigNested<N>>
    implements ContainerCreateRequestFluent.HostConfigNested<N> {
        private final HostConfigBuilder builder;

        HostConfigNestedImpl() {
            this.builder = new HostConfigBuilder(this);
        }

        HostConfigNestedImpl(HostConfig item) {
            this.builder = new HostConfigBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)ContainerCreateRequestFluentImpl.this.withHostConfig(this.builder.build());
        }

        @Override
        public N endHostConfig() {
            return this.and();
        }
    }
}

