/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableServiceConfig;
import io.fabric8.docker.api.model.ServiceConfig;
import io.fabric8.docker.api.model.ServiceConfigFluent;
import io.fabric8.docker.api.model.ServiceConfigFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ServiceConfigBuilder
extends ServiceConfigFluentImpl<ServiceConfigBuilder>
implements VisitableBuilder<ServiceConfig, ServiceConfigBuilder> {
    ServiceConfigFluent<?> fluent;

    public ServiceConfigBuilder() {
        this(new ServiceConfig());
    }

    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent) {
        this(fluent, new ServiceConfig());
    }

    public ServiceConfigBuilder(ServiceConfigFluent<?> fluent, ServiceConfig instance) {
        this.fluent = fluent;
        fluent.withIndexConfigs(instance.getIndexConfigs());
        fluent.withInsecureRegistryCIDRs(instance.getInsecureRegistryCIDRs());
        fluent.withMirrors(instance.getMirrors());
    }

    public ServiceConfigBuilder(ServiceConfig instance) {
        this.fluent = this;
        this.withIndexConfigs(instance.getIndexConfigs());
        this.withInsecureRegistryCIDRs(instance.getInsecureRegistryCIDRs());
        this.withMirrors(instance.getMirrors());
    }

    @Override
    public EditableServiceConfig build() {
        EditableServiceConfig buildable = new EditableServiceConfig(this.fluent.getIndexConfigs(), this.fluent.getInsecureRegistryCIDRs(), this.fluent.getMirrors());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceConfigBuilder that = (ServiceConfigBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

