/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditablePortBinding;
import io.fabric8.docker.api.model.PortBinding;
import io.fabric8.docker.api.model.PortBindingFluent;
import io.fabric8.docker.api.model.PortBindingFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class PortBindingBuilder
extends PortBindingFluentImpl<PortBindingBuilder>
implements VisitableBuilder<PortBinding, PortBindingBuilder> {
    PortBindingFluent<?> fluent;

    public PortBindingBuilder() {
        this(new PortBinding());
    }

    public PortBindingBuilder(PortBindingFluent<?> fluent) {
        this(fluent, new PortBinding());
    }

    public PortBindingBuilder(PortBindingFluent<?> fluent, PortBinding instance) {
        this.fluent = fluent;
        fluent.withHostIp(instance.getHostIp());
        fluent.withHostPort(instance.getHostPort());
    }

    public PortBindingBuilder(PortBinding instance) {
        this.fluent = this;
        this.withHostIp(instance.getHostIp());
        this.withHostPort(instance.getHostPort());
    }

    @Override
    public EditablePortBinding build() {
        EditablePortBinding buildable = new EditablePortBinding(this.fluent.getHostIp(), this.fluent.getHostPort());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PortBindingBuilder that = (PortBindingBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

