/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.CPUStats;
import io.fabric8.docker.api.model.CPUStatsFluent;
import io.fabric8.docker.api.model.CPUUsage;
import io.fabric8.docker.api.model.CPUUsageBuilder;
import io.fabric8.docker.api.model.CPUUsageFluentImpl;
import io.fabric8.docker.api.model.ThrottlingData;
import io.fabric8.docker.api.model.ThrottlingDataBuilder;
import io.fabric8.docker.api.model.ThrottlingDataFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class CPUStatsFluentImpl<T extends CPUStatsFluent<T>>
extends BaseFluent<T>
implements CPUStatsFluent<T> {
    VisitableBuilder<CPUUsage, ?> cpuUsage;
    Long systemCpuUsage;
    VisitableBuilder<ThrottlingData, ?> throttlingData;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public CPUStatsFluentImpl() {
    }

    public CPUStatsFluentImpl(CPUStats instance) {
        this.withCpuUsage(instance.getCpuUsage());
        this.withSystemCpuUsage(instance.getSystemCpuUsage());
        this.withThrottlingData(instance.getThrottlingData());
    }

    @Override
    public CPUUsage getCpuUsage() {
        return this.cpuUsage != null ? (CPUUsage)this.cpuUsage.build() : null;
    }

    @Override
    public T withCpuUsage(CPUUsage cpuUsage) {
        if (cpuUsage != null) {
            this.cpuUsage = new CPUUsageBuilder(cpuUsage);
            this._visitables.add(this.cpuUsage);
        }
        return (T)this;
    }

    @Override
    public CPUStatsFluent.CpuUsageNested<T> withNewCpuUsage() {
        return new CpuUsageNestedImpl();
    }

    @Override
    public CPUStatsFluent.CpuUsageNested<T> withNewCpuUsageLike(CPUUsage item) {
        return new CpuUsageNestedImpl(item);
    }

    @Override
    public CPUStatsFluent.CpuUsageNested<T> editCpuUsage() {
        return this.withNewCpuUsageLike(this.getCpuUsage());
    }

    @Override
    public Long getSystemCpuUsage() {
        return this.systemCpuUsage;
    }

    @Override
    public T withSystemCpuUsage(Long systemCpuUsage) {
        this.systemCpuUsage = systemCpuUsage;
        return (T)this;
    }

    @Override
    public ThrottlingData getThrottlingData() {
        return this.throttlingData != null ? (ThrottlingData)this.throttlingData.build() : null;
    }

    @Override
    public T withThrottlingData(ThrottlingData throttlingData) {
        if (throttlingData != null) {
            this.throttlingData = new ThrottlingDataBuilder(throttlingData);
            this._visitables.add(this.throttlingData);
        }
        return (T)this;
    }

    @Override
    public CPUStatsFluent.ThrottlingDataNested<T> withNewThrottlingData() {
        return new ThrottlingDataNestedImpl();
    }

    @Override
    public CPUStatsFluent.ThrottlingDataNested<T> withNewThrottlingDataLike(ThrottlingData item) {
        return new ThrottlingDataNestedImpl(item);
    }

    @Override
    public CPUStatsFluent.ThrottlingDataNested<T> editThrottlingData() {
        return this.withNewThrottlingDataLike(this.getThrottlingData());
    }

    @Override
    public T withNewThrottlingData(Long periods, Long throttledPeriods, Long throttledTime) {
        return this.withThrottlingData(new ThrottlingData(periods, throttledPeriods, throttledTime));
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CPUStatsFluentImpl that = (CPUStatsFluentImpl)o;
        if (this.cpuUsage != null ? !this.cpuUsage.equals(that.cpuUsage) : that.cpuUsage != null) {
            return false;
        }
        if (this.systemCpuUsage != null ? !this.systemCpuUsage.equals(that.systemCpuUsage) : that.systemCpuUsage != null) {
            return false;
        }
        if (this.throttlingData != null ? !this.throttlingData.equals(that.throttlingData) : that.throttlingData != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ThrottlingDataNestedImpl<N>
    extends ThrottlingDataFluentImpl<CPUStatsFluent.ThrottlingDataNested<N>>
    implements CPUStatsFluent.ThrottlingDataNested<N> {
        private final ThrottlingDataBuilder builder;

        ThrottlingDataNestedImpl() {
            this.builder = new ThrottlingDataBuilder(this);
        }

        ThrottlingDataNestedImpl(ThrottlingData item) {
            this.builder = new ThrottlingDataBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)CPUStatsFluentImpl.this.withThrottlingData(this.builder.build());
        }

        @Override
        public N endThrottlingData() {
            return this.and();
        }
    }

    public class CpuUsageNestedImpl<N>
    extends CPUUsageFluentImpl<CPUStatsFluent.CpuUsageNested<N>>
    implements CPUStatsFluent.CpuUsageNested<N> {
        private final CPUUsageBuilder builder;

        CpuUsageNestedImpl() {
            this.builder = new CPUUsageBuilder(this);
        }

        CpuUsageNestedImpl(CPUUsage item) {
            this.builder = new CPUUsageBuilder(this, item);
        }

        @Override
        public N endCpuUsage() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)CPUStatsFluentImpl.this.withCpuUsage(this.builder.build());
        }
    }
}

