package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;
import io.fabric8.docker.api.builder.VisitableBuilder;

public class VolumeCreateRequestBuilder extends VolumeCreateRequestFluentImpl<VolumeCreateRequestBuilder> implements VisitableBuilder<VolumeCreateRequest,VolumeCreateRequestBuilder>{

     VolumeCreateRequestFluent<?> fluent;
public VolumeCreateRequestBuilder(){
    this(new VolumeCreateRequest());
}
public VolumeCreateRequestBuilder( VolumeCreateRequestFluent<?> fluent ){
    this(fluent, new VolumeCreateRequest());
}
public VolumeCreateRequestBuilder( VolumeCreateRequestFluent<?> fluent , VolumeCreateRequest instance ){
    this.fluent = fluent; fluent.withDriver(instance.getDriver()); fluent.withDriverOpts(instance.getDriverOpts()); fluent.withName(instance.getName()); 
}
public VolumeCreateRequestBuilder( VolumeCreateRequest instance ){
    this.fluent = this; this.withDriver(instance.getDriver()); this.withDriverOpts(instance.getDriverOpts()); this.withName(instance.getName()); 
}

public EditableVolumeCreateRequest build(){
    EditableVolumeCreateRequest buildable = new EditableVolumeCreateRequest(fluent.getDriver(),fluent.getDriverOpts(),fluent.getName());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
VolumeCreateRequestBuilder that = (VolumeCreateRequestBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
