package io.fabric8.docker.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.Fluent;

public class ThrottlingDataFluentImpl<T extends ThrottlingDataFluent<T>> extends BaseFluent<T> implements ThrottlingDataFluent<T>{

     Long periods;     Long throttledPeriods;     Long throttledTime;     Map<String, Object> additionalProperties = new HashMap();
public ThrottlingDataFluentImpl(){
    
}
public ThrottlingDataFluentImpl( ThrottlingData instance ){
    this.withPeriods(instance.getPeriods()); this.withThrottledPeriods(instance.getThrottledPeriods()); this.withThrottledTime(instance.getThrottledTime()); 
}

    public Long getPeriods(){
    return this.periods;
    }
    public T withPeriods( Long periods){
    this.periods=periods; return (T) this;
    }
    public Long getThrottledPeriods(){
    return this.throttledPeriods;
    }
    public T withThrottledPeriods( Long throttledPeriods){
    this.throttledPeriods=throttledPeriods; return (T) this;
    }
    public Long getThrottledTime(){
    return this.throttledTime;
    }
    public T withThrottledTime( Long throttledTime){
    this.throttledTime=throttledTime; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ThrottlingDataFluentImpl that = (ThrottlingDataFluentImpl) o;
if (periods != null ? !periods.equals(that.periods) :that.periods != null) return false;
if (throttledPeriods != null ? !throttledPeriods.equals(that.throttledPeriods) :that.throttledPeriods != null) return false;
if (throttledTime != null ? !throttledTime.equals(that.throttledTime) :that.throttledTime != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
