package io.fabric8.docker.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import java.util.AbstractCollection;
import java.util.List;
import java.util.Map;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;

public interface NetworkSettingsBaseFluent<T extends NetworkSettingsBaseFluent<T>> extends Fluent<T>{


    public String getBridge();    public T withBridge( String Bridge);    public Boolean isHairpinMode();    public T withHairpinMode( Boolean HairpinMode);    public String getLinkLocalIPv6Address();    public T withLinkLocalIPv6Address( String LinkLocalIPv6Address);    public Integer getLinkLocalIPv6PrefixLen();    public T withLinkLocalIPv6PrefixLen( Integer LinkLocalIPv6PrefixLen);    public T addToPorts( String key,  ArrayList<PortBinding> value);    public T addToPorts( Map<String, ArrayList<PortBinding>> map);    public T removeFromPorts( String key);    public T removeFromPorts( Map<String, ArrayList<PortBinding>> map);    public Map<String, ArrayList<PortBinding>> getPorts();    public T withPorts( Map<String, ArrayList<PortBinding>> Ports);    public String getSandboxID();    public T withSandboxID( String SandboxID);    public String getSandboxKey();    public T withSandboxKey( String SandboxKey);    public T addToSecondaryIPAddresses( Address ...items);    public T removeFromSecondaryIPAddresses( Address ...items);    public List<Address> getSecondaryIPAddresses();    public T withSecondaryIPAddresses( List<Address> SecondaryIPAddresses);    public T withSecondaryIPAddresses( Address ...SecondaryIPAddresses);    public SecondaryIPAddressesNested<T> addNewSecondaryIPAddresse();    public SecondaryIPAddressesNested<T> addNewSecondaryIPAddresseLike( Address item);    public T addNewSecondaryIPAddresse( String Addr,  Integer PrefixLen);    public T addToSecondaryIPv6Addresses( Address ...items);    public T removeFromSecondaryIPv6Addresses( Address ...items);    public List<Address> getSecondaryIPv6Addresses();    public T withSecondaryIPv6Addresses( List<Address> SecondaryIPv6Addresses);    public T withSecondaryIPv6Addresses( Address ...SecondaryIPv6Addresses);    public SecondaryIPv6AddressesNested<T> addNewSecondaryIPv6Addresse();    public SecondaryIPv6AddressesNested<T> addNewSecondaryIPv6AddresseLike( Address item);    public T addNewSecondaryIPv6Addresse( String Addr,  Integer PrefixLen);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface SecondaryIPAddressesNested<N> extends Nested<N>,AddressFluent<SecondaryIPAddressesNested<N>>{
            public N endSecondaryIPAddresse();            public N and();        
}

    public interface SecondaryIPv6AddressesNested<N> extends Nested<N>,AddressFluent<SecondaryIPv6AddressesNested<N>>{
            public N and();            public N endSecondaryIPv6Addresse();        
}


}
