package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.Fluent;

public class NetworkCreateBuilder extends NetworkCreateFluentImpl<NetworkCreateBuilder> implements VisitableBuilder<NetworkCreate,NetworkCreateBuilder>{

     NetworkCreateFluent<?> fluent;
public NetworkCreateBuilder(){
    this(new NetworkCreate());
}
public NetworkCreateBuilder( NetworkCreateFluent<?> fluent ){
    this(fluent, new NetworkCreate());
}
public NetworkCreateBuilder( NetworkCreateFluent<?> fluent , NetworkCreate instance ){
    this.fluent = fluent; fluent.withCheckDuplicate(instance.getCheckDuplicate()); fluent.withDriver(instance.getDriver()); fluent.withIPAM(instance.getIPAM()); fluent.withName(instance.getName()); fluent.withOptions(instance.getOptions()); 
}
public NetworkCreateBuilder( NetworkCreate instance ){
    this.fluent = this; this.withCheckDuplicate(instance.getCheckDuplicate()); this.withDriver(instance.getDriver()); this.withIPAM(instance.getIPAM()); this.withName(instance.getName()); this.withOptions(instance.getOptions()); 
}

public EditableNetworkCreate build(){
    EditableNetworkCreate buildable = new EditableNetworkCreate(fluent.isCheckDuplicate(),fluent.getDriver(),fluent.getIPAM(),fluent.getName(),fluent.getOptions());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
NetworkCreateBuilder that = (NetworkCreateBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
