package io.fabric8.docker.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.Builder;
import io.fabric8.docker.api.builder.Visitable;
import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.builder.Fluent;

public class ContainerStateBuilder extends ContainerStateFluentImpl<ContainerStateBuilder> implements VisitableBuilder<ContainerState,ContainerStateBuilder>{

     ContainerStateFluent<?> fluent;
public ContainerStateBuilder(){
    this(new ContainerState());
}
public ContainerStateBuilder( ContainerStateFluent<?> fluent ){
    this(fluent, new ContainerState());
}
public ContainerStateBuilder( ContainerStateFluent<?> fluent , ContainerState instance ){
    this.fluent = fluent; fluent.withDead(instance.getDead()); fluent.withError(instance.getError()); fluent.withExitCode(instance.getExitCode()); fluent.withFinishedAt(instance.getFinishedAt()); fluent.withOOMKilled(instance.getOOMKilled()); fluent.withPaused(instance.getPaused()); fluent.withPid(instance.getPid()); fluent.withRestarting(instance.getRestarting()); fluent.withRunning(instance.getRunning()); fluent.withStartedAt(instance.getStartedAt()); fluent.withStatus(instance.getStatus()); 
}
public ContainerStateBuilder( ContainerState instance ){
    this.fluent = this; this.withDead(instance.getDead()); this.withError(instance.getError()); this.withExitCode(instance.getExitCode()); this.withFinishedAt(instance.getFinishedAt()); this.withOOMKilled(instance.getOOMKilled()); this.withPaused(instance.getPaused()); this.withPid(instance.getPid()); this.withRestarting(instance.getRestarting()); this.withRunning(instance.getRunning()); this.withStartedAt(instance.getStartedAt()); this.withStatus(instance.getStatus()); 
}

public EditableContainerState build(){
    EditableContainerState buildable = new EditableContainerState(fluent.isDead(),fluent.getError(),fluent.getExitCode(),fluent.getFinishedAt(),fluent.isOOMKilled(),fluent.isPaused(),fluent.getPid(),fluent.isRestarting(),fluent.isRunning(),fluent.getStartedAt(),fluent.getStatus());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ContainerStateBuilder that = (ContainerStateBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
