package io.fabric8.docker.api.model;

import java.util.Map;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.docker.api.builder.Nested;
import io.fabric8.docker.api.builder.Fluent;

public interface ContainerCreateRequestFluent<T extends ContainerCreateRequestFluent<T>> extends Fluent<T>{


    public String getName();    public T withName( String name);    public String getHostname();    public T withHostname( String hostname);    public String getDomainname();    public T withDomainname( String domainname);    public String getUser();    public T withUser( String user);    public String getMemory();    public T withMemory( String memory);    public String getMemorySwap();    public T withMemorySwap( String memorySwap);    public String getMemoryReservation();    public T withMemoryReservation( String memoryReservation);    public String getKernelMemory();    public T withKernelMemory( String kernelMemory);    public String getCpuShares();    public T withCpuShares( String cpuShares);    public String getCpuPeriod();    public T withCpuPeriod( String cpuPeriod);    public String getCpuQuota();    public T withCpuQuota( String cpuQuota);    public String getCpuset();    public T withCpuset( String cpuset);    public String getCpusetCpus();    public T withCpusetCpus( String cpusetCpus);    public String getCpusetMems();    public T withCpusetMems( String cpusetMems);    public Integer getBlkioWeight();    public T withBlkioWeight( Integer blkioWeight);    public Integer getMemorySwappiness();    public T withMemorySwappiness( Integer memorySwappiness);    public Boolean isOomKillDisable();    public T withOomKillDisable( Boolean oomKillDisable);    public Boolean isAttachStdin();    public T withAttachStdin( Boolean attachStdin);    public Boolean isAttachStdout();    public T withAttachStdout( Boolean attachStdout);    public Boolean isAttachStderr();    public T withAttachStderr( Boolean attachStderr);    public Boolean isTty();    public T withTty( Boolean tty);    public Boolean isOpenStdin();    public T withOpenStdin( Boolean openStdin);    public Boolean isStdinOnce();    public T withStdinOnce( Boolean stdinOnce);    public T addToEnv( String key,  String value);    public T addToEnv( Map<String, String> map);    public T removeFromEnv( String key);    public T removeFromEnv( Map<String, String> map);    public Map<String, String> getEnv();    public T withEnv( Map<String, String> env);    public T addToCmd( String ...items);    public T removeFromCmd( String ...items);    public List<String> getCmd();    public T withCmd( List<String> cmd);    public T withCmd( String ...cmd);    public String getEntrypoint();    public T withEntrypoint( String entrypoint);    public String getImage();    public T withImage( String image);    public T addToLabels( String key,  String value);    public T addToLabels( Map<String, String> map);    public T removeFromLabels( String key);    public T removeFromLabels( Map<String, String> map);    public Map<String, String> getLabels();    public T withLabels( Map<String, String> labels);    public T addToMounts( String key,  String value);    public T addToMounts( Map<String, String> map);    public T removeFromMounts( String key);    public T removeFromMounts( Map<String, String> map);    public Map<String, String> getMounts();    public T withMounts( Map<String, String> mounts);    public String getWorkingDir();    public T withWorkingDir( String workingDir);    public Boolean isNetworkDisabled();    public T withNetworkDisabled( Boolean networkDisabled);    public String getMacAddress();    public T withMacAddress( String macAddress);    public T addToExposedPorts( Integer key,  Protocol value);    public T addToExposedPorts( Map<Integer, Protocol> map);    public T removeFromExposedPorts( Integer key);    public T removeFromExposedPorts( Map<Integer, Protocol> map);    public Map<Integer, Protocol> getExposedPorts();    public T withExposedPorts( Map<Integer, Protocol> exposedPorts);    public String getStopSignal();    public T withStopSignal( String stopSignal);    public HostConfig getHostConfig();    public T withHostConfig( HostConfig hostConfig);    public HostConfigNested<T> withNewHostConfig();    public HostConfigNested<T> withNewHostConfigLike( HostConfig item);    public HostConfigNested<T> editHostConfig();
    public interface HostConfigNested<N> extends Nested<N>,HostConfigFluent<HostConfigNested<N>>{
            public N and();            public N endHostConfig();        
}


}
