/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.BaseFluent;
import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.SearchResult;
import io.fabric8.docker.api.model.SearchResultBuilder;
import io.fabric8.docker.api.model.SearchResultFluentImpl;
import io.fabric8.docker.api.model.SearchResults;
import io.fabric8.docker.api.model.SearchResultsFluent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchResultsFluentImpl<T extends SearchResultsFluent<T>>
extends BaseFluent<T>
implements SearchResultsFluent<T> {
    Integer numResults;
    String query;
    List<VisitableBuilder<SearchResult, ?>> results = new ArrayList();
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public SearchResultsFluentImpl() {
    }

    public SearchResultsFluentImpl(SearchResults instance) {
        this.withNumResults(instance.getNumResults());
        this.withQuery(instance.getQuery());
        this.withResults(instance.getResults());
    }

    @Override
    public Integer getNumResults() {
        return this.numResults;
    }

    @Override
    public T withNumResults(Integer numResults) {
        this.numResults = numResults;
        return (T)this;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public T withQuery(String query) {
        this.query = query;
        return (T)this;
    }

    @Override
    public T addToResults(SearchResult ... items) {
        for (SearchResult item : items) {
            SearchResultBuilder builder = new SearchResultBuilder(item);
            this._visitables.add(builder);
            this.results.add(builder);
        }
        return (T)this;
    }

    @Override
    public T removeFromResults(SearchResult ... items) {
        for (SearchResult item : items) {
            SearchResultBuilder builder = new SearchResultBuilder(item);
            this._visitables.remove(builder);
            this.results.remove(builder);
        }
        return (T)this;
    }

    @Override
    public List<SearchResult> getResults() {
        return this.build(this.results);
    }

    @Override
    public T withResults(List<SearchResult> results) {
        this.results.clear();
        if (results != null) {
            for (SearchResult item : results) {
                this.addToResults(item);
            }
        }
        return (T)this;
    }

    @Override
    public T withResults(SearchResult ... results) {
        this.results.clear();
        if (results != null) {
            for (SearchResult item : results) {
                this.addToResults(item);
            }
        }
        return (T)this;
    }

    @Override
    public SearchResultsFluent.ResultsNested<T> addNewResult() {
        return new ResultsNestedImpl();
    }

    @Override
    public SearchResultsFluent.ResultsNested<T> addNewResultLike(SearchResult item) {
        return new ResultsNestedImpl(item);
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchResultsFluentImpl that = (SearchResultsFluentImpl)o;
        if (this.numResults != null ? !this.numResults.equals(that.numResults) : that.numResults != null) {
            return false;
        }
        if (this.query != null ? !this.query.equals(that.query) : that.query != null) {
            return false;
        }
        if (this.results != null ? !this.results.equals(that.results) : that.results != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class ResultsNestedImpl<N>
    extends SearchResultFluentImpl<SearchResultsFluent.ResultsNested<N>>
    implements SearchResultsFluent.ResultsNested<N> {
        private final SearchResultBuilder builder;

        ResultsNestedImpl() {
            this.builder = new SearchResultBuilder(this);
        }

        ResultsNestedImpl(SearchResult item) {
            this.builder = new SearchResultBuilder(this, item);
        }

        @Override
        public N endResult() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)SearchResultsFluentImpl.this.addToResults(this.builder.build());
        }
    }
}

