/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableRestartPolicy;
import io.fabric8.docker.api.model.RestartPolicy;
import io.fabric8.docker.api.model.RestartPolicyFluent;
import io.fabric8.docker.api.model.RestartPolicyFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class RestartPolicyBuilder
extends RestartPolicyFluentImpl<RestartPolicyBuilder>
implements VisitableBuilder<RestartPolicy, RestartPolicyBuilder> {
    RestartPolicyFluent<?> fluent;

    public RestartPolicyBuilder() {
        this(new RestartPolicy());
    }

    public RestartPolicyBuilder(RestartPolicyFluent<?> fluent) {
        this(fluent, new RestartPolicy());
    }

    public RestartPolicyBuilder(RestartPolicyFluent<?> fluent, RestartPolicy instance) {
        this.fluent = fluent;
        fluent.withMaximumRetryCount(instance.getMaximumRetryCount());
        fluent.withName(instance.getName());
    }

    public RestartPolicyBuilder(RestartPolicy instance) {
        this.fluent = this;
        this.withMaximumRetryCount(instance.getMaximumRetryCount());
        this.withName(instance.getName());
    }

    @Override
    public EditableRestartPolicy build() {
        EditableRestartPolicy buildable = new EditableRestartPolicy(this.fluent.getMaximumRetryCount(), this.fluent.getName());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RestartPolicyBuilder that = (RestartPolicyBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

