/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableNetworkCreate;
import io.fabric8.docker.api.model.NetworkCreate;
import io.fabric8.docker.api.model.NetworkCreateFluent;
import io.fabric8.docker.api.model.NetworkCreateFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NetworkCreateBuilder
extends NetworkCreateFluentImpl<NetworkCreateBuilder>
implements VisitableBuilder<NetworkCreate, NetworkCreateBuilder> {
    NetworkCreateFluent<?> fluent;

    public NetworkCreateBuilder() {
        this(new NetworkCreate());
    }

    public NetworkCreateBuilder(NetworkCreateFluent<?> fluent) {
        this(fluent, new NetworkCreate());
    }

    public NetworkCreateBuilder(NetworkCreateFluent<?> fluent, NetworkCreate instance) {
        this.fluent = fluent;
        fluent.withCheckDuplicate(instance.getCheckDuplicate());
        fluent.withDriver(instance.getDriver());
        fluent.withIPAM(instance.getIPAM());
        fluent.withName(instance.getName());
        fluent.withOptions(instance.getOptions());
    }

    public NetworkCreateBuilder(NetworkCreate instance) {
        this.fluent = this;
        this.withCheckDuplicate(instance.getCheckDuplicate());
        this.withDriver(instance.getDriver());
        this.withIPAM(instance.getIPAM());
        this.withName(instance.getName());
        this.withOptions(instance.getOptions());
    }

    @Override
    public EditableNetworkCreate build() {
        EditableNetworkCreate buildable = new EditableNetworkCreate(this.fluent.isCheckDuplicate(), this.fluent.getDriver(), this.fluent.getIPAM(), this.fluent.getName(), this.fluent.getOptions());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkCreateBuilder that = (NetworkCreateBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

