/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableMemoryStats;
import io.fabric8.docker.api.model.MemoryStats;
import io.fabric8.docker.api.model.MemoryStatsFluent;
import io.fabric8.docker.api.model.MemoryStatsFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class MemoryStatsBuilder
extends MemoryStatsFluentImpl<MemoryStatsBuilder>
implements VisitableBuilder<MemoryStats, MemoryStatsBuilder> {
    MemoryStatsFluent<?> fluent;

    public MemoryStatsBuilder() {
        this(new MemoryStats());
    }

    public MemoryStatsBuilder(MemoryStatsFluent<?> fluent) {
        this(fluent, new MemoryStats());
    }

    public MemoryStatsBuilder(MemoryStatsFluent<?> fluent, MemoryStats instance) {
        this.fluent = fluent;
        fluent.withFailcnt(instance.getFailcnt());
        fluent.withLimit(instance.getLimit());
        fluent.withMaxUsage(instance.getMaxUsage());
        fluent.withStats(instance.getStats());
        fluent.withUsage(instance.getUsage());
    }

    public MemoryStatsBuilder(MemoryStats instance) {
        this.fluent = this;
        this.withFailcnt(instance.getFailcnt());
        this.withLimit(instance.getLimit());
        this.withMaxUsage(instance.getMaxUsage());
        this.withStats(instance.getStats());
        this.withUsage(instance.getUsage());
    }

    @Override
    public EditableMemoryStats build() {
        EditableMemoryStats buildable = new EditableMemoryStats(this.fluent.getFailcnt(), this.fluent.getLimit(), this.fluent.getMaxUsage(), this.fluent.getStats(), this.fluent.getUsage());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MemoryStatsBuilder that = (MemoryStatsBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

