/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.docker.api.model;

import io.fabric8.docker.api.builder.VisitableBuilder;
import io.fabric8.docker.api.model.EditableIPAMConfig;
import io.fabric8.docker.api.model.IPAMConfig;
import io.fabric8.docker.api.model.IPAMConfigFluent;
import io.fabric8.docker.api.model.IPAMConfigFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class IPAMConfigBuilder
extends IPAMConfigFluentImpl<IPAMConfigBuilder>
implements VisitableBuilder<IPAMConfig, IPAMConfigBuilder> {
    IPAMConfigFluent<?> fluent;

    public IPAMConfigBuilder() {
        this(new IPAMConfig());
    }

    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent) {
        this(fluent, new IPAMConfig());
    }

    public IPAMConfigBuilder(IPAMConfigFluent<?> fluent, IPAMConfig instance) {
        this.fluent = fluent;
        fluent.withAuxiliaryAddresses(instance.getAuxiliaryAddresses());
        fluent.withGateway(instance.getGateway());
        fluent.withIPRange(instance.getIPRange());
        fluent.withSubnet(instance.getSubnet());
    }

    public IPAMConfigBuilder(IPAMConfig instance) {
        this.fluent = this;
        this.withAuxiliaryAddresses(instance.getAuxiliaryAddresses());
        this.withGateway(instance.getGateway());
        this.withIPRange(instance.getIPRange());
        this.withSubnet(instance.getSubnet());
    }

    @Override
    public EditableIPAMConfig build() {
        EditableIPAMConfig buildable = new EditableIPAMConfig(this.fluent.getAuxiliaryAddresses(), this.fluent.getGateway(), this.fluent.getIPRange(), this.fluent.getSubnet());
        this.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IPAMConfigBuilder that = (IPAMConfigBuilder)o;
        return !(this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this);
    }

    private <T> void validate(T item) {
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            Validator validator = factory.getValidator();
            Set violations = validator.validate(item, new Class[0]);
            if (!violations.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Constraint Violations:\n");
                for (ConstraintViolation violation : violations) {
                    sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
                }
                throw new IllegalStateException(sb.toString());
            }
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }
}

